# THIS procedure retrieves all of the database entries in a database for
#   the virtual defined by Key within a specified time range

package provide TclUDFdB 1.0

proc DBgetEntries { Key Yb Db Msb Ye De Mse dBType { VOnly 0 } } {
   global env DataList UDFPaths 
   
# INVERT the key to get the UDF lineage acronyms.  This allows us to form
#    the database file names

   set Src [split [UDFinvKey $Key]]

# OBTAIN the necessary local UDF paths for this data set.  The  paths are 
#    returned in the global array variable UDFPaths.  The definitions are:
#          UDFPaths(0) : the PIDF directory
#          UDFPaths(1) : the Database directory
#          UDFPaths(2) : the HD Data directory
                                                                                
   UDFdirPaths [lindex $Src 0] [lindex $Src 1] [lindex $Src 2] [lindex $Src 3]
                                                                                
# THIS is the path/name of the DBF database file for this experiment

   set dbF [file join $UDFPaths(1) [lindex $Src 3].$dBType.DBF]
   if ![file exists $dbF] { return "" }

# OPEN the database file

   DBdbfOpen $dbF dB

#  SET up the requested begin and end times as single strings

   set utB [format "%4d%03d%08d" $Yb $Db $Msb]
   set utE  [format "%4d%03d%08d" $Ye $De $Mse]

# LOOP over the database records pulling out those which belong to the
#   requested Virtual and are within the time specified.

   set Vr [lindex $Src 4]
   set fList ""
   for { set I 0 } { $I < $dB(NumRecs) } { incr I } {
      set ToRec [expr $dB(HLen) + $dB(RecLen) * $I ]
      TUfileSeek $dB(fd) $ToRec start
      set dBRec [read $dB(fd) $dB(RecLen)]
#     binary scan $dBRec aa8a4a3a8a4a3a8 sP V bY bD bMs eY eD eMs
      binary scan $dBRec "aa8a4a3a8a4a3a8a10aaa2a3a8" sP V \
                        bY bD bMs eY eD eMs Sz P1 P2 St Arc dT

      set V [string trim $V]
      if ![string match $V $Vr] { continue } 

      set dtB [format "%4d%03d%08d" $bY $bD $bMs]
      set dtE [format "%4d%03d%08d" $eY $eD $eMs]

      if { [DBtimeCmp $dtB $dtE $utB $utE] != 0 } {
         set bTm [format "%4d%03d%08d" $bY $bD $bMs]
         set eTm [format "%4d%03d%08d" $eY $eD $eMs]
         if !$VOnly  {
            set Mn [expr int(($bMs % 3600000) / 60000 )]
            set Hr [expr int($bMs / 3600000)]
            set Tm [format "%4d%03d%02d%02d" $bY $bD $Hr $Mn]
            lappend fList "$V$Tm $bTm $eTm $dT"
         } else { lappend fList "$V $bTm $eTm $dT" }
      }
   }

   close $dB(fd)
   return $fList
}
