#  THIS procedure opens a DBF file and reads the header information.  
#    Once the header information has been read there are three things
#    the procedure can do depending on how the input Virtual is set.
#
#  IF virtual remains a null string the routine returns after getting
#    the database header information.  If it is set to ALLVIRTUALS the
#    procedure returns a time ordered list (min to max) of all of the
#    database entries.  If Virtual is set to a specific virtual
#    the procedure returns a time ordered list (min to max) of all of
#    the entries for that virtual.

package provide TclUDFdB 1.0

proc DBdbfOpen { dbF dBInfo { Virtual ALLVIRTUALS  } { openAs r } } {

   upvar $dBInfo dB

#  OPEN the file as binary, read the header block and pull out the total 
#     number of records in the file as well as the number of fields per 
#     record.  
#
#  NOTE there appears to be a problem in Tcl>8.4.11 with a+ opens and 
#     possibly a opens.  I have implemented a workaround here.

   if [ file exists $dbF ] {
      switch -exact -- $openAs {
         a  -
         a+ {
            if [catch {open $dbF r+} dB(fd) ] {
               puts stderr "DBdbfOpen:  CANNOT OPEN FILE $dbF"
               return -1
            }
            seek $dB(fd) 0 end
	 }
         default {
            if [catch {open $dbF $openAs} dB(fd) ] {
               puts stderr "DBdbfOpen:  CANNOT OPEN FILE $dbF"
               return -1
            }
         }
      }
   } else { puts stderr "NO DATABASE FILE $dbF" ; return -1 }
 
#  READ the header information.  This includes the current number of entries
#    and the record length 

   seek $dB(fd) 0 start
   fconfigure $dB(fd) -translation binary
   set dB(Head) [read $dB(fd) 32]

   binary scan $dB(Head) "@4i" dB(NumRecs)
   binary scan $dB(Head) "@8s" dB(HLen)
   binary scan $dB(Head) "@10s" dB(RecLen)
   set dB(LonG) i

   set Rest [expr $dB(HLen) - 32]
   set Head [read $dB(fd) $Rest]

#  NOW read in what fields are held in each record

   set dB(NumFlds) [expr int(($Rest - 1) /  32)]
   set dB(FldNames) ""
   set dB(FldTypes) ""
   set dB(FldLens) ""
   set J 0
   for { set I 0 } { $I < $dB(NumFlds) } { incr I } {
       binary scan $Head @${J}a11aii NamE Type TmP Len
       lappend dB(FldNames) $NamE
       lappend dB(FldTypes) $Type
       lappend dB(FldLens) $Len
       incr J +32
   }

#  WE are either looking for information on a specific virtual or want
#   information on all of them

   if [string match ALLVIRTUALS $Virtual] {
      set Vlen -1
   } else { set Vlen [string length $Virtual] } 

#  MAKE a couple of precheck.  NO records or no virtual name = nothing to do

   set dB(KeyList) ""
   if { ($dB(NumRecs) == 0) || ($Vlen == 0) } { return 1 }

# START culling the database information from the header information

   set Entries ""
   if { $Vlen > 0 } {
      for { set I 0 } { $I < $dB(NumRecs) } { incr I } {
         set ToRec [expr $dB(HLen) + $dB(RecLen) * $I ]
         seek $dB(fd) $ToRec start
         set dBRec [read $dB(fd) $dB(RecLen)]
         binary scan $dBRec aa38a10aaa2a3a8 Sp Key Size P1 Comp St Arc Date
         binary scan $Key a8 V
         set V [string trimleft $V]
         set V [string trimright $V]
         if [string match $V $Virtual] { 
            lappend Entries [list $Key $I $Arc $Comp] 
         }
      } 

      if { [llength $Entries] > 0 } {
         set dB(KeyList) [lsort -ascii -increasing -index 0 $Entries]
      } 
   } else { 
      for { set I 0 } { $I < $dB(NumRecs) } { incr I } {
         set ToRec [expr $dB(HLen) + $dB(RecLen) * $I ]
         seek $dB(fd) $ToRec start
         set dBRec [read $dB(fd) $dB(RecLen)]
         binary scan $dBRec aa38a10aaa2a3a8 Sp Key Size P1 Comp St Arc Date
         lappend Entries [list $Key $I $Arc $Comp]
      } 

      if { [llength $Entries] > 0 } {
         set dB(KeyList) [lsort -ascii -increasing -index 0 $Entries]
      } 
   }

   return 1
}
