#  THIS procedure deletes a list of entries from a DBF database file.  
#
#  NOTE the database should be not be open by another routine when
#    this procedure is called. 

package provide TclUDFdB 1.0

proc DBdbfDelete { dbF dBPos } {

   
# OPEN up the database 

    DBdbfOpen $dbF dB

# OPEN up the temporary database file where the entries from the current
#   database will be stored sans the deleted entry

    if [catch {open ._TmPdB w} fo ] {
       puts stderr "DBdbfDelete:  CANNOT OPEN FILE ._TmPDb"
       return 1
    }
    fconfigure $fo -translation binary

# NUMBER of deletes to perform

    set dLen [llength $dBPos]

# NUMBER of entries which will be left in database

    set NumE [expr $dB(NumRecs) - $dLen]

# IF deleting these entries will empty the database then just remove it 

    if { $NumE <= 0 } {
       close $dB(fd)
       close $fo
       file delete -force ._TmPdB
       file delete -force $dbF
       unset dB
       return
    }

# READ/WRITE back the modified header

   fconfigure $dB(fd) -translation binary
   seek $dB(fd) 0 start

   set Head [read $dB(fd) 32]
                                                                                
   puts -nonewline $fo [string range $Head 0 3]
   puts -nonewline $fo [binary format $dB(LonG) $NumE ]
   puts -nonewline $fo [string range $Head 8 end]

   set Rest [expr $dB(HLen) - 32]
   set Head [read $dB(fd) $Rest]
   puts -nonewline $fo $Head

# ORDER the delete list

  set oList [lsort -integer -increasing $dBPos]

# NOW copy the database entries into the temporary database skipping those
#   that are to be deleted

   set BeG 0
   for { set I 0 } { $I < $dLen } { incr I } {
      set EnD [lindex $oList $I] 
      for { set J $BeG } { $J < $EnD } { incr J } {
         set dRec [read $dB(fd) $dB(RecLen)]
         puts -nonewline $fo $dRec 
      }
      set dRec [read $dB(fd) $dB(RecLen)]
      set BeG [expr $EnD + 1]
   }

# COPY all the remaining entries after the last deleted entry into the 
#    temporary database

   for { set J $BeG } { $J < $dB(NumRecs) } { incr J } {
      set dRec [read $dB(fd) $dB(RecLen)]
      puts -nonewline $fo $dRec 
   }

# CLOSE the current and temporary databases and them move the temporary
#   database to be the new current one.

   close $dB(fd)
   close $fo
   file rename -force ._TmPdB $dbF
}
