#
#  This procedure creates a DBF database file and fills the header information 
#
#  Returns:   1   Database created and initialized
#            -1   Could not create Database file
#            -2   Database exists already

package provide TclUDFdB 1.0

proc DBdbfCreate { DBFname } {
   global env

# IF the DBF database file already exists don't overwrite it!  Make some
#   other routine or someone else remove it first.

   if [file exists $DBFname] { return -2 }

# CREATE the DBF database and make sure its binary

   if [catch {open $DBFname w} DBFfd ] { return -1 }
   fconfigure $DBFfd -translation binary

# THESE are the fields created within the database

   set F(0)  [list V_INST C 8 0]
   set F(1)  [list B_YR N 4 0]
   set F(2)  [list B_DAY N 3 0]
   set F(3)  [list B_MSEC N 8 0]
   set F(4)  [list E_YR N 4 0]
   set F(5)  [list E_DAY N 3 0]
   set F(6)  [list E_MSEC N 8 0]
   set F(7)  [list SIZE N 10 0]
   set F(8)  [list PREPROC C 1 0]
   set F(9)  [list POSTPROC C 1 0]
   set F(10) [list STATE C 2 0]
   set F(11) [list ARCH_LAB C 3 0]
   set F(12) [list DATE D 8 0]
   
# SET up the field definitions in a binary format.  While doing this
#    establish the record length of a database record and also how
#    large the database header will be.

   set dBHLen 33
   set Empty ""
   set dBRecLen 1
   for { set I 0 } { $I < 13 } { incr I } {
      set Items [split $F($I)]
      set Field($I) [binary format "a11aiia12" \
                          [lindex $Items 0] [lindex $Items 1] \
                          [lindex $Items 3] [lindex $Items 2] $Empty ]
      incr dBRecLen [lindex $Items 2]
      incr dBHLen 32
   }

# SET up the first 32 bytes in the database header.  Only the first 12 have
#   pertinent data.  This is:
#
# Byte 0       is set to 3
# Byte 1       is month of last update [1-12]
# Byte 2       is day of last update
# Byte 3       is year of last update
# Bytes 4-7    is Number of Records in file
# Bytes 8-9    is byte length of Header
# Bytes 10-11  is byte length of Record

   set dBFmt 3
   set Empty ""
   set Time [split [clock format [clock seconds] -format %D] "/"]
   set T1 [string trimleft [lindex $Time 0] "0"]
   set T2 [string trimleft [lindex $Time 1] "0"]
   set T3 [string trimleft [lindex $Time 2] "0"]
   if { [string length $T1] == 0 } { set T1 0 }
   if { [string length $T2] == 0 } { set T2 0 }
   if { [string length $T3] == 0 } { set T3 0 }
   set dBNRecs 0

   set Head [binary format "ccccissa20" $dBFmt $T1 $T2 $T3 \
                                        $dBNRecs $dBHLen $dBRecLen $Empty ]

# WRITE out the first part of the dabase header record

   puts -nonewline $DBFfd $Head
   
# NOW write out the field descriptions

   for { set I 0 } { $I < 13 } { incr I } { puts -nonewline $DBFfd $Field($I) }

# CLOSE it out

   set ReT 13
   puts -nonewline $DBFfd [binary format "c" $ReT] 

# SHUT it down

   close $DBFfd
   return 1
}
