# THIS procedure appends entries to a database file 
#
# Inputs: 
#   dbN  - The database name
#   dbE  - A file name of individual entries
#
#  Returns:   N   Position of first appended entry 
#            -1   Could not open the Database file
#            -2   Could not open the entry file

package provide TclUDFdB 1.0

proc DBdbfAppend { dbN dbE } {
   global env

# QUICK check to make sure that both the database and entry file exist.

   if ![file exists $dbN] { DBdbfCreate $dbN }
   if ![file exists $dbE] { return -2 }

# OPEN the database file 

   if { [DBdbfOpen $dbN dB "" a+] != 1 } { return -1 }
   fconfigure $dB(fd) -translation binary
   seek $dB(fd) 0 end

# OPEN the entry file

   if [catch {open $dbE r} fd ] { return -2 } 

# POSITION in the dbf file of the first appended entry

   set aPos $dB(NumRecs)

# PROCESS the database entries

   while { [gets $fd LiNe] >= 0 } {
       set Fields [split $LiNe "|"]
       set Space " "
       set V    [lindex $Fields 0]
       set By   [format "%4s" [lindex $Fields 1] ]
       set Bd   [format "%3s" [lindex $Fields 2] ]
       set Bms  [format "%8s" [lindex $Fields 3] ]
       set Ey   [format "%4s" [lindex $Fields 4] ]
       set Ed   [format "%3s" [lindex $Fields 5] ]
       set Ems  [format "%8s" [lindex $Fields 6] ]
       set Size [format "%10s" [lindex $Fields 7] ]
       set P1   [lindex $Fields 8]
       set P2   [lindex $Fields 9]
       set St   [lindex $Fields 10]
       set Arc  [lindex $Fields 11]
       set Dt   [lindex $Fields 12]
       set Entry [binary format "AA8A4A3A8A4A3A8A10AAA2A3A8" $Space $V \
                  $By $Bd $Bms $Ey $Ed $Ems $Size $P1 $P2 $St $Arc $Dt]
       puts -nonewline $dB(fd) $Entry
       incr dB(NumRecs)
   }

   seek $dB(fd) 0 start
   puts -nonewline $dB(fd) [string range $dB(Head) 0 3]
   seek $dB(fd) 4 start
   puts -nonewline $dB(fd) [binary format i $dB(NumRecs) ]
   seek $dB(fd) 8 start
   puts -nonewline $dB(fd) [string range $dB(Head) 8 end]
   
   close $dB(fd)
   close $fd

   return $aPos
}
