# Determine if a UDF data set is in the native integer format or not.  If
#   it is not then convert it to the native format.
#
# INPUTS:
#   Vf:   UDF VIDF file
#   Hf:   UDF Header file
#   Df:   UDF Data file

package provide TclUDFdB 1.0

proc DBautoSwap { Vf Hf Df } {
   global UDFdataOrder

# IF we need to convert this is the from and to formats

   if [string match littleEndian $UDFdataOrder] {
      set iBf B
      set oBf L
      set nB2 s
      set nB4 i
   } else {
      set iBf L
      set oBf B
      set nB2 S
      set nB4 I
   }

# OPEN the header file as read and the data file 

   if [catch {open $Hf r} fh] {
      puts stderr "DBautoSwap: Can't Open $Hf"
      return -1
   }
   if [catch {open $Df r} fd] {
      puts stderr "DBautoSwap: Can't Open $Df"
      close $fh
      return -1
   }
   fconfigure $fh -translation binary
   fconfigure $fd -translation binary

# GET the YEAR and DAY from the first record in the header file

   binary scan [read $fh 6] ${nB2}${nB2}${nB2} hSz Yr Dy

# GET the TIME from the first record in the data file

   binary scan [read $fd 4] ${nB4} Tm

# CLOSE the files

   close $fh
   close $fd

# STRIP out the time field of the data file name

   set fLen [string length $Df]
   set fTm [string range $Df [expr $fLen - 12] [expr $fLen -2]]

# FORM the same name from the time fields obtained from the data files
 
   set Hr [expr int( $Tm / 3600000)]
   set Mn [expr int(($Tm % 3600000) / 60000)]
   set dTm [format "%d%03d%02d%02d" $Yr $Dy $Hr $Mn]

# IF the two times match then assume the data is in the correct format
#   otherwise swap it.

   if ![string match $dTm $fTm] { DBudfSwap $Vf $Hf $Df $iBf $oBf } 
}
