# RETURNS
#  1  OK
#  0  No data for this field
# -1  Bad field name
# -2  0 or less data values requested
# -3  beg offset larger than number of values
# -4  end offset larger than number of values

package provide TclUDF 1.0

proc UDFvidfChk { K Tbl Blk } {
   global SInfo VFields VSize VDeps ByTe_4

   set P $K,PT

   if { $Tbl == 0 } { 
      set Pos [lsearch -exact $VFields PADEFINED]
      binary scan $SInfo($P,GOFFS) @[expr 4 * $Pos]$ByTe_4 Offset
      binary scan $SInfo($K,VIDF) @${Offset}c1 Var

      if { $Var > 0 } {
         set VDeps(PABXBYBZ) 3
         set VDeps(PATBLS) PAAPPS
         set VDeps(PAOPS) PAAPPS
      }
   } else {
      set TLoc [lsearch -exact $VFields TBLSCASZ]
      set CLoc [lsearch -exact $VFields CONSTID]
      set Loc [lsearch -exact $VFields CRITACTSZ]
      set InDx [expr ($CLoc - $TLoc) * $Blk + $Loc - $TLoc]
      binary scan $SInfo($P,TOFFS) @[expr 4 * $InDx]$ByTe_4 Off
      set FmT @${Off}c1
      binary scan $SInfo($K,VIDF) $FmT Var
      if { $Var > 0 } {
         set VDeps(CRITSTATUS) SEN
         set VDeps(CRITOFF) SEN
      }
   }
}
