#  ADVANCE to the next time (next measurement)

package provide TclUDF 1.0

proc UDFtimeNext { kV N } {
   global SInfo ByTe_4 

   set P $kV,PT
   set S $kV,SS

#  SET the sensor set STATE to current and then advance all of the needed
#      pointers to get to the next measurement

   set SInfo($S,STATE) 0
   UDFssptrAdv $kV $N

#  IF we have gone into the next sensor set then there are several things
#      which need to be checked and done
 
   if { $SInfo($S,STATE) == 1 } { 

#  IF we have exceeded the number of sensor sets in the data record then 
#     we need to get the next data record.  If there are more sensor
#     sets then set the pointer to the next sensor set.  REMEMBER to
#     advance the accumulated time so that it points to the beginning
#     of the new sensor set.  DO THIS BEFORE reading information for the next
#     sensor set! 

      UDFretVar $kV NSS NSS
      if { $SInfo($S,CURSS) >= [expr abs($NSS)] } { 
         UDFreadDATA $kV -1 
         UDFretVar $kV NSS NSS
      } else { 
         UDFresetAccum $kV
         incr SInfo($P,TOSS) $SInfo($S,SSBYTES) 
      }

#  IF we have moved from the current sensor set they we may need to get a
#     new header record.  Establish the Header Number and read.  The
#     read will only be done if the current header is different than the
#     new header.

      if { $NSS < 0 } { set HNum 0 } else { set HNum $SInfo($S,CURSS) }
      set rV [UDFreadHDR $kV $HNum]

#  IF EOF then on to next file otherwise definitely need to reset the sensor 
#      set base times and byte position

      if { $rV < 0 } { set rV [UDFnextFile $kV] } 
   } else { set rV 1 }
   return $rV
}
