# RETURNS (list):
#            
#  ReT  dec_bday dec_eday  bmsec  bnsec  emsec  ensec

#package provide TclUDF_C 1.0
package provide TclUDF 1.0

proc UDFtimeData { K N { TmRow -1 } { TmCol -1 } } {
   global SInfo ExDa

   set G $K,GN
   set S $K,SS
   set T $K,TM

#  Set the current number of data samples in the sensor set

   UDFretVar $K NSMP NSmP
   if { $TmRow < 0 } { set TmRow $SInfo($S,TMROW) } 
   if { $TmCol < 0 } { set TmCol $SInfo($S,TMCOL) } 

#  If this is a matrix sensor then we need to modify the TIME COL to reflect
#  the current relative matrix column number

   if { $SInfo($G,SMPID) == 3 } { 
       UDFretVar $K LEADCOL LC
       incr TmCol [expr $ExDa($N,COL) - $LC]
   }

#  GET the start time of the current measurement using all timing elements.
#     TIME and TIME_OFF are not used in the nanoseconds workup since they 
#     are returned in milliseconds only

   set BDec 0
   set EDec 0
   UDFretVar $K TIME TM
   set TMOFF [lindex $SInfo($G,TIMEOFF) $ExDa($N,SEN)]

   set BMs [expr $TM + $TMOFF + $SInfo($T,TOTMS) + \
                    [expr $TmRow * $SInfo($T,COLMS)] + \
                    [expr $TmCol * $SInfo($T,ROWMS)] ]

   set BNs [expr $SInfo($T,TOTNS) + \
                    [expr $TmRow * $SInfo($T,COLNS)] + \
                    [expr $TmCol * $SInfo($T,ROWNS)] ]

#
#  Correct for a negative Msec time which can be generated if TIMEOFF is
#  negative
#

   if {$BMs < 0} {
      set BDec 1
      incr BMs 86400000
   }

#  If too many NSec - then some in Msec.  For reference: there are
#  1e6 Nsec in 1 Msec.

   incr BMs [expr int($BNs / 1000000) ]
   set  BNs [expr $BNs % 1000000 ]

#  OK - we got the beginning time - now get the ending time.  This is a
#  bit more complicated.  
#
#  If the sensor set columns are parallel then all that needs to be done is 
#  to increment the beginning time by the sample time, otherwise we need to 
#  know the effective ending row of the samples being returned. This depends 
#  on if the data is scalar or array and if its an array on the DAMETHOD set
#  for the data.
#

   set TCP [expr 1 - ($SInfo($G,SENMODE) % 2)] 

   if {$TCP == 0 } {
      set EMs [expr $BMs + $SInfo($T,SMPMS)]
      set ENs [expr $BNs + $SInfo($T,SMPNS)]
   } else {
       set ERow 1
       if { $SInfo($G,SMPID) == 2 } {
          if {$ExDa($N,FULLSWP) == 1 } { set ERow [expr $NsmP - $TmRow] }
 
          if {$ERow == 1} { 
             set ERow [expr $TmRow + 1]
          } else { set ERow $NSmP }
       } else { 
          UDFretVar $K SCAN Sc 1
          switch -exact -- $SInfo($G,DAMETHOD) {
             0       {  set ERow $NSmP              }
             1       {  set ERow $SInfo($G,SCANLEN) }
             3       {  if {$NsmP != 1 } {
                           set ERow [expr abs(Sc(1) - $Sc(0)) * $NsmP]
                       }
                     }
 
             default { set End [expr $NsmP - 1]
                       set ERow [expr abs($Sc($End) - $Sc(0))]
                     }
          }
       }
 
       set EMs [expr $TM + $TMOFF + $SInfo($T,TOTMS) + \
                        [expr $ERow * $SInfo($T,COLMS)] + \
                        [expr $TmCol * $SInfo($T,ROWMS)] ]
 
       set ENs [expr $SInfo($T,TOTNS) + \
                        [expr $ERow * $SInfo($T,COLNS)] + \
                        [expr $TmCol * $SInfo($T,ROWNS)] ]
   }

   if {$EMs < 0} {
      set EDec 1
      incr EMs 86400000
   }
   incr EMs [expr int($ENs / 1000000) ]
   set  ENs [expr $ENs % 1000000 ]
 
   set ReT [list $BDec $EDec $BMs $BNs $EMs $ENs ]

   return $ReT
}
