#package provide TclUDF_C 1.0
package provide TclUDF 1.0

proc UDFtimeComps { K } {
   global SInfo ExDa ByTe_2 ByTe_4

   set G $K,GN
   set T $K,TM

#
#  Get the number of sensors and samples in this sensor set.  Also
#  get the total number of columns of data in the sensor set
#
  
   set TotCols [expr $SInfo($K,NCOLS) * $SInfo($K,NSEN) ]

   UDFretVar $K HTIMES TInfo
   UDFretVar $K TSCALE TSca

   set SInfo($T,LATMS)   [expr [lindex $TInfo 1] / 1000]
   set SInfo($T,LATNS)   [expr ([lindex $TInfo 1] % 1000) * 1000]
   set SInfo($T,SRSTMS)  [expr [lindex $TInfo 2] / 1000]
   set SInfo($T,SRSTNS)  [expr ([lindex $TInfo 2] % 1000) * 1000]
   set SInfo($T,SSRSTMS) [expr [lindex $TInfo 3] / 1000]
   set SInfo($T,SSRSTNS) [expr ([lindex $TInfo 3] % 1000) * 1000]

   set Ms [expr 1000.0 * [lindex $TInfo 0] * pow (10.0, $TSca)]
   set SInfo($T,ACCMS)   [expr int($Ms) ]
   set SInfo($T,ACCNS)   [expr int(fmod ($Ms, 1) * 1000000.0) ]

#
# Set up time between two consecutive measurements
#

   set SInfo($T,SMPMS)   [expr $SInfo($T,ACCMS) + $SInfo($T,LATMS)]
   set SInfo($T,SMPNS)   [expr $SInfo($T,ACCNS) + $SInfo($T,LATNS)]

#
# Set up time between two consecutive measurements in the same data column
#

   set TRC [expr 1 - $SInfo($G,SENMODE) / 4]
   set TRP [expr 1 - (($SInfo($G,SENMODE) % 4) / 2)]
   set TCP [expr 1 - ($SInfo($G,SENMODE) % 2)]
   set dRC [expr 1 - $TRC]
   set dRP [expr 1 - $TRP]
   set dCP [expr 1 - $TCP]

   set SInfo($T,COLMS) [expr $TCP * ($TRC * $SInfo($T,SMPMS) + $dRC * \
                        (($TotCols * $TRP + $dRP) * $SInfo($T,SMPMS) + \
                         $SInfo($T,SRSTMS)))]

   set SInfo($T,COLNS) [expr $TCP * ($TRC * $SInfo($T,SMPNS) + $dRC * \
                        (($TotCols * $TRP + $dRP) * $SInfo($T,SMPNS) + \
                         $SInfo($T,SRSTNS)))]

#
# Set up time between two consecutive measurements in the same data row
#

   set SInfo($T,ROWMS) [expr $TRP * ($dRC * $SInfo($T,SMPMS) + $TRC * \
                        (($SInfo($K,NSMP) * $TCP + $dCP) * $SInfo($T,SMPMS) \
                         + $SInfo($T,SRSTMS)))]

   set SInfo($T,ROWNS) [expr $TRP * ($dRC * $SInfo($T,SMPNS) + $TRC * \
                        (($SInfo($K,NSMP) * $TCP + $dCP) * $SInfo($T,SMPNS) \
                         + $SInfo($T,SRSTNS)))]
}
