package provide TclUDF 1.0

proc UDFpidfSensor { N fd } {
   global Pidf$N

   set TmP Pidf$N
   upvar 0 $TmP P

   set P1 {^[ ]*([^ ]*).([^ ]*)[ =]*([^;]*).(.*)}
   set P2 {^[ ]*([^ ]*).([^ ]*)[ ="]*([^"]*)..(.*)}
   set P3 {^[ ]*([^ ]*).([^ ]*)[ =']*([^']*)..(.*)}

   set uL [ list Name Comp Src SCF Pa VidfN AncS GrpN ScanBlk Units ]
   set uD(0)  "" 
   set uD(1)  "" 
   set uD(2)   V 
   set uD(3)  "" 
   set uD(4)   N 
   set uD(5)  -1 
   set uD(6)  -1
   set uD(7)  -1 
   set uD(8)  -1 
   set uD(9)  "" 

   gets $fd Line
   regexp "\[ \t\]*(.)" $Line M End
   while {[string compare $End "\}"] != 0 } {
      regexp "$P1" $Line M T Fld V Com
      if [string match string* $T] { 
         regexp "$P2" $Line M T Fld V Com
      } elseif [string match char* $T] { regexp "$P3" $Line M T Fld V Com }

      if ![string match struct* $T] { 
         switch -glob -- $Fld {
            name*               {  set uD(0)    $V  }
            component*          {  set uD(1)    $V  }
            source*             {  set uD(2) [string trim $V "'"]  }
            scf_filename*       {  set uD(3)    $V  }
            pitch_angle_flag*   {  set uD(4) [string trim $V "'"]  }
            vidf_sensor_num*    {  set uD(5)    $V  }
            anc_sensor*         {  set uD(6)    $V  }
            group_num*          {  set uD(7)    $V  }
            scan_block_info*    {  set uD(8)    $V  }
            unit_number*        {  lappend uD(9) $V } 
         }
      }
      gets $fd Line
      regexp "\[ \t\]*(.)" $Line M End
   }

   set P(SenPidfN) $P(NSens)
   set Len [llength $uL]
   for { set I 0 } { $I < $Len } { incr I } {
      lappend P(Sen[lindex $uL $I]) $uD($I)
   }

   lappend P(SenNunits) [llength $uD(9)]
   incr P(NSens)
}
