package provide TclUDF 1.0

proc UDFpidfAnc { N fd } {
   global Pidf$N

   set TmP Pidf$N
   upvar 0 $TmP P

   set P1 {^[ ]*([^ ]*).([^ ]*)[ =]*([^;]*).(.*)}
   set P2 {^[ ]*([^ ]*).([^ ]*)[ ="]*([^"]*)..(.*)}
   set P3 {^[ ]*([^ ]*).([^ ]*)[ =']*([^']*)..(.*)}

   set uL [ list Name SName VidfN Units Sens ]
   set uD(0)  "" 
   set uD(1)  "" 
   set uD(2)   V 
   set uD(3)  "" 
   set uD(4)  "" 

   gets $fd Line
   regexp "\[ \t\]*(.)" $Line M End
   while { [string compare $End "\}"] != 0 } {
      regexp "$P1" $Line M T Fld V Com
      if [string match string* $T] { 
          regexp "$P2" $Line M T Fld V Com
      } elseif [string match char* $T] { regexp "$P3" $Line M T Fld V Com }

      if { [string match struct* $T] == 0 } { 
         switch -glob -- $Fld  {
            name*                {  set uD(0)     $V    }
            short_name*          {  set uD(1)     $V    }
            vidf_cal_num*        {  set uD(2)     $V    }
            unit_number*         {  append uD(3)  $V    }
            cal_based_on_sensor* {  append uD(4) "$V"   }
         }
      }
      gets $fd Line
      regexp "\[ \t\]*(.)" $Line M End
   }

   set P(AncPidfN) $P(NAncs)
   set Len [llength $uL]
   for { set I 0 } { $I < $Len } { incr I } {
      lappend P(Anc[lindex $uL $I]) $uD($I)
   }

   lappend P(AncNunits) [llength $uD(3)]
   lappend P(AncNSen) [llength $uD(4)]
   incr P(NAncs)
}
