# Takes a UDF key and returns the PMEIV

package provide TclUDF 1.0

proc UDFinvKey { Key } {
   global env AllPMEIV

   UDFcfgPMEIVList 
   set PmEiV ""

   set R AllPMEIV
   global [set R]
   set Len [llength [set $R]]
   set V [expr ($Key >> 23) - 1]
   set Pr [lindex [set $R] $V]
   append PmEiV $Pr

   set R $Pr
   global [set R]
   set Len [llength [set $R]]
   set V [expr (($Key & 7864320) >> 19) - 1]
   set Mi [lindex [set $R] $V]
   append PmEiV " $Mi"

   set R $Pr.$Mi
   global [set R]
   set Len [llength [set $R]]
   set V [expr (($Key & 516096) >> 13) - 1]
   set Ex [lindex [set $R] $V]
   append PmEiV " $Ex"

   set R $Pr.$Mi.$Ex
   global [set R]
   set V [expr (($Key & 8064) >> 7) - 1]
   set In [lindex [set $R] $V]
   append PmEiV " $In"

   set R $Pr.$Mi.$Ex.$In
   global [set R]
   set Len [llength [set $R]]
   set V [expr ($Key & 127) - 1]
   set Vr [lindex [set $R] $V]
   append PmEiV " $Vr"

   return $PmEiV
}
