#
#  FINDS the file in the HDList which contains the starting time
#
#  MustBeIn:  0 - if the specified time is proir to the start time of the
#                  first file in the list then the first file should be opened.
#             1 - the specified time must be contained in one of the files.
#
#  Return are:
#     0 - Time is before first file
#     1 - Time is contained in a file
#     2 - Time is after the last file
#     3 - No available VIDF file
#

package provide TclUDF 1.0

proc UDFfileFirst { K Yr Dy Hr Mn Ss { MustBeIn 0 } } {
   global SInfo ByTe_4 ByTe_2

# GET input time to milliseconds and then set up the current time string

   set Ms [expr int($Hr * 3600000 + $Mn * 60000 + $Ss * 1000)] 
   set cTm [format "%4d%03d%08d" $Yr $Dy $Ms ]

# MAKE local copy of head and data file descriptors and then configure them
#   so that they are accessing binary data.

   set fd $SInfo($K,DFD)
   set fh $SInfo($K,HFD)
   fconfigure $fd -translation binary
   fconfigure $fh -translation binary

# LOOP over all the files in the assembled VIDF list which was created in the 
#   FileOpen call.  This contains all of the VIDF files which cover the time
#   range used in the FileOpen call.  Find out which file contains the input 
#   time.  If the file found is not currently open then set the ReOpen flag.

   set InBounds 2
   set ReOpenV 0
   set I 0
   set Len [llength $SInfo($K,VLIST)]
   while {($InBounds == 2) && ($I < $Len) } {
      set bTm [lindex [lindex $SInfo($K,VLIST) $I] 1]
      set eTm [lindex [lindex $SInfo($K,VLIST) $I] 2]
      set tList [lsort -ascii -increasing [list $bTm $eTm $cTm]]
      if { [lsearch -exact $tList $cTm] == 2 } {
        incr I
      } else { 
         set InBounds 1 
         if { $I !=  $SInfo($K,VNUM) } {
            set ReOpenV 1
            set SInfo($K,VNUM) $I
         }
      }
   }

# IF there is no VIDF file covering this time then we can't do anything so
#   leave with error.

   if {$InBounds == 2 } { return 3 }

# LOOP over all the files in the HEADER/DATA list which was created in the 
#   FileOpen call.  This contains all of the UDF files which have data in 
#   the time range used in the FileOpen call.  Find out which file contains 
#   the input time.  If a file is found then check to see if this is the 
#   currently open file.  If so OK - but if not then set the ReOpen flag.  

   set InBounds 2
   set ReOpenHD 0
   set I 0
   set Len [llength $SInfo($K,HDLIST)]
   while {($InBounds == 2) && ($I < $Len) } {
      set bTm [lindex [lindex $SInfo($K,HDLIST) $I] 1]
      set eTm [lindex [lindex $SInfo($K,HDLIST) $I] 2]
      set tList [lsort -ascii -increasing [list $bTm $eTm $cTm]]
      set InBounds [lsearch -exact $tList $cTm]
      if { $InBounds == 0 } {
         if [string match $cTm [lindex $tList 1]] { 
            set InBounds 1
          } else { set InBounds 0 }
      } elseif { $InBounds == 2 } { incr I }
   }

# DONE if this is MustBeIn 1 and the time isn't found in any file

   if { ($MustBeIn == 1) && ($InBounds != 1) } { return $InBounds }

# IF we found a file which contains the time then we need to see if it needs
#   to be opened or not.

   if {$InBounds != 2 } {
      if { $I !=  $SInfo($K,HDNUM) } {
          set ReOpenHD 1
          set SInfo($K,HDNUM) $I
      }
      if { $ReOpenHD == 1 } {
         catch { close $SInfo($K,DFD) } MsG
         catch { close $SInfo($K,HFD) } MsG
         set SInfo($K,HFD)  ""
         set SInfo($K,DFD)  ""
      }
      if { $ReOpenV == 1 } {
         catch { close $SInfo($K,VFD) } MsG
         set SInfo($K,VFD)  ""
      }
      set SInfo($K,FSTATUS) [UDFfileOpen $K] 
   }

   return $InBounds
}
