package provide TclUDF_C 1.0
#package provide TclUDF 1.0

proc UDFdataSen { K N SenPos } {
   global SInfo ExDa ByTe_2 ByTe_4 ExData$N

   set G $K,GN
   set S $K,SS
   set P $K,PT

   set TmP ExData$N
   upvar 0 $TmP X

#  DETERMINE the number of measurements being returned and the current
#     column (cC) of the data

   UDFretVar $K NSMP NSmP 
   if { ($SInfo($G,SMPID) == 2) && ($ExDa($N,FULLSWP) == 0)} {
        set Elem 1
   } else { set Elem [expr $NSmP - $SInfo($S,TMROW)] }

# IF data is in matrix format then we need the column number otherwise the
#   column number is just the sensor position

   if { ($SInfo($G,SMPID) == 3) } {
      UDFretVar $K COLDATA cI 1
      set cC  [expr $SenPos * $cI(0) + ($ExDa($N,COL) - $cI(1))] 
   } else { set cC $SenPos }

#  SET the format to use when reading the

   set FmT [UDFFmt $SInfo($G,SBLEN) ]

#  SET byte offset to the data to be read

   set Off [expr $SInfo($P,TOSS) + $SInfo($G,SBLEN) * \
                                  ( $NSmP * $cC + $SInfo($S,TMROW))]
   binary scan $SInfo($K,DATA) @$Off$FmT$Elem Data
   UDFArray $Data ExData$N

   set ExDa($N,NSMP) [llength $Data]
   unset Data

#
#  Get the data into the native format.  Tcl reads data as signed values
#  so if the raw data is unsigned then we need to convert it as we need
#  to do if the data is floating point data
#

   set Bits [lindex $SInfo($G,SLEN) $ExDa($N,SEN)]
   set FmT [lindex $SInfo($G,DTYPE) $ExDa($N,SEN)]
   if {$FmT == 0 } { UDFUnsign $Bits $ExDa($N,NSMP) ExData$N 
   } elseif { $FmT > 1 } { UDFFloat X $ExDa($N,NSMP) $FmT }
}
