#package provide TclUDF_C 1.0
package provide TclUDF 1.0

proc UDFdataPhi { K N } {
   global SInfo ExDa ByTe_2 ByTe_4 ExPhi$N

   set G $K,GN
   set S $K,SS
   set T $K,TM
   set P $K,PT

   set TmP ExPhi$N
   upvar 0 $TmP X

#  Determine the number of measurements being returned and the current
#  column (cC) of the data
 
   UDFretVar $K NSMP NSmP 
   if { ($SInfo($G,SMPID) == 2) && ($ExDa($N,FULLSWP) == 0)} {
        set Elem 1
   } else { set Elem [expr $NSmP - $SInfo($S,TMROW)] }

   set J $Elem
   if { [info exists SInfo($G,PHI) ] == 0 } { 
     set aO 0
   } else { set aO [lindex $SInfo($G,PHI) $ExDa($N,SEN)] }
   if {$ExDa($N,SPIN) == 0 } {
      set DegAcc 0
      set Ang [expr $aO + $ExDa($N,ZERO) / 100.0]
      set Ang [expr fmod($Ang, 360.0) ] 
      for { set I 0 } { $I < $Elem } {incr I } {
         set X($I) $Ang
         set X($J) $Ang
         incr J
      }
   } else {
      set AccTm [expr $SInfo($T,SMPMS) + $SInfo($T,SMPNS) * 1.0e-6]
      set DegPMs [expr 360.0 / $ExDa($N,SPIN) ]
      set DegAcc [expr $AccTm * $DegPMs]
      set bT [expr $ExDa($N,RBMSEC) - $ExDa($N,ZERO)]
      UDFretVar $K SCAN Sc 1
      switch -exact -- $SInfo($G,SENMODE) {
         0 -
         2   {  
            set bA [expr $aO + $bT * $DegPMs ]
            switch -exact -- $SInfo($G,DAMETHOD) {
               0 {  set cT [expr $SInfo($S,TMROW) * $AccTm]
                    for { set I 0 } { $I < $Elem } {incr I } {
                        set X($I) [expr $bA + $cT * $DegPMs ]
                        set cT [ expr $cT + $AccTm]
                    }
                 }
               1 {  for { set I 0 } { $I < $Elem } {incr I } {
                        set cT [expr $Sc($I) * $AccTm]
                        set X($I) [expr $bA + $cT * $DegPMs ]
                    }
                 }
              2 -
              3 {  for { set I 0 } { $I < $Elem } {incr I } {
                       set cT [expr abs($Sc(0) - $Sc($I)) * $AccTm]
                       set X($I) [expr $bA + $cT * $DegPMs ]
                    }
                 }
            }
         }
         1 -
         3  {  
            for { set I 0 } { $I < $Elem } {incr I } {
                set X($I) [expr $aO + $bT * $DegPMs]
             }
         }
         default {
            set TimeRow $SInfo($S,TMROW)
            set bT [expr $aO  - $ExDa($N,ZERO) * $DegPMs]
            for { set I 0 } { $I < $Elem } {incr I } {
               set Tm [UDFtimeData $K $N $TimeRow]
               set X($I) [expr $bT + [lindex $Tm 2] * $DegPMs]
               incr TimeRow
            }
         }
      }

#
#  Get all of the starting Phi's between 0 and 360.0
#

      for { set I 0 } { $I < $Elem } {incr I } {
         set X($I) [expr fmod($X($I), 360.0) ] 
         if { $X($I) < 0.0 } { set X($I) [expr $X($I) + 360.0] } 
      }

      if { (($SInfo($G,SENMODE) == 0) || ($SInfo($G,SENMODE) == 2)) && \
                                               ($SInfo($G,DAMETHOD) == 3) } {
         for { set I 1 } { $I < $Elem } {incr I } {
            set X($J) $X($I) 
            incr J
         }
         incr I -1
         set X($J) [expr $X($I) + $DegAcc]
      } else {
         for { set I 0 } { $I < $Elem } {incr I } {
            set X($J) [expr $X($I) + $DegAcc]
            incr J
         }
      }
   }
}
