#  PROCEDURE takes a data source and copies it into an array expanding it if
#     necessary to the same length as the current sensor data.

package provide TclUDF_C 1.0
#package provide TclUDF 1.0

proc UDFdataFill { kV N Src SubSrc Out { OBuf 0} } {
   global SInfo ExDa ExData$N ExScan$N ExMode$N ExAnc$N   

   set G $kV,GN
   set P $kV,PT

   upvar $Out X
   set M [expr $OBuf * $ExDa($N,NSMP)]
   set KeeP $M

   switch -exact -- $Src {
      SENSOR -
      0 {  set TmP ExData$N
           upvar 0 $TmP V 
           for { set I 0 } {$I < $ExDa($N,NSMP) } { incr I } {
              set X($M) $V($I)
              incr M
           }
        }
      SCAN -
      2 {  set TmP ExScan$N
           upvar 0 $TmP V 
           for { set I 0 } {$I < $ExDa($N,NSMP) } { incr I } {
              set X($M) $V($I)
              incr M
           }
        }
      MODE -
      4 {  set TmP ExMode$N
           upvar 0 $TmP V 
           set End [expr $M + $ExDa($N,NSMP)]
           for { set I $M } {$I < $End } { incr I } {
              set X($I) $V($SubSrc)
           }
        }
      default {
           set TmP ExAnc$N
           upvar 0 $TmP V 

           if { $SubSrc < 0 } { set SubSrc [expr  -1 - $SubSrc] }
           set End [expr $M + $SInfo($kV,NSMP)]
           set K [lindex $SInfo($P,ASET) $SubSrc]
           set Hold [lindex $SInfo($G,AUSE) $SubSrc]
           if { $Hold == 0 } { set Hold $SInfo($kV,NSMP) }
           for { set I $M  } {$I < $End } { incr K } {
              set J 0
              while { ($J < $Hold) && ($I < $End) } {
                  set X($I) $V($K)
                  incr I
                  incr J
              }
           }

# IF this ancillary data is associated with a scalar source then return
#   the values needed.

           if {$SInfo($G,SMPID) == 2 } {
              set J [expr $SInfo($kV,SS,TMROW) + $KeeP]
              set End [ expr $J + $ExDa($N,NSMP)]
              for { set I $KeeP } {$J < $End } { incr I ; incr J } {
                 set X($I) $X($J)
              }
           }
      }
   }
}
