package provide TclUDF 1.0

proc UDFdataAnc { K N SenPos } {
   global SInfo ExDa ByTe_2 ByTe_4 ExAnc$N

   set G $K,GN
   set S $K,SS
   set P $K,PT
   set Kd $K,DATA

   set TmP ExAnc$N
   upvar 0 $TmP X

#  Read in all the ancillary data

   set PBeg 0
   if { $SInfo($K,NPANC) > 0 } {
      set FmT [UDFFmt $SInfo($G,APBLEN) ]
      binary scan $SInfo($Kd) @$SInfo($P,TOPANC)$FmT$SInfo($K,NPANC) Data
      UDFArray $Data X
   }

   set GBeg $SInfo($K,NPANC)
   set Off [expr $SInfo($P,TOSS) + $SInfo($S,SBYTES)]
   if { $SInfo($K,NGANC) > 0 } {
      set FmT [UDFFmt $SInfo($G,AGBLEN) ]
      binary scan $SInfo($Kd) @$Off$FmT$SInfo($K,NGANC) Data
      UDFArray $Data X $GBeg
   }

   set SBeg [expr $GBeg + $SInfo($K,NGANC) ]
   if { $SInfo($K,NSANC) > 0 } {
      set TC [expr $SInfo($K,NSEN) * $SInfo($K,NCOLS)]
      set FmT [UDFFmt $SInfo($G,ASBLEN) ]
      set pSen [expr $SInfo($K,NSANC) / $TC ]
      incr Off [expr $SInfo($S,AGBYTES) + $SenPos * $pSen * $SInfo($G,ASBLEN)]
      binary scan $SInfo($Kd) @$Off$FmT$pSen Data
      UDFArray $Data X $SBeg
   }

   set SInfo($P,ASET) ""
   for {set I 0} {$I < $SInfo($G,ANUM) } {incr I } {
      switch -exact -- [lindex $SInfo($G,ATARGET) $I] {
         0 { lappend SInfo($P,ASET) $SBeg 
             set Bits [lindex $SInfo($G,ABLEN) $I]
             if { $Bits > 0 } { 
                UDFUnsign $Bits [lindex $SInfo($K,ASETN) $I] X $SBeg 
             }
             incr SBeg [lindex $SInfo($K,ASETN) $I]  
         }
         2 { lappend SInfo($P,ASET) $GBeg
             set Bits [lindex $SInfo($G,ABLEN) $I]
             if { $Bits > 0 } { 
                UDFUnsign $Bits [lindex $SInfo($K,ASETN) $I] X $GBeg 
             }
             incr GBeg [lindex $SInfo($K,ASETN) $I]  
         }
         3 { lappend SInfo($P,ASET) $PBeg
             set Bits [lindex $SInfo($G,ABLEN) $I]
             if { $Bits > 0 } { 
                UDFUnsign $Bits [lindex $SInfo($K,ASETN) $I] X $PBeg 
             }
             incr PBeg [lindex $SInfo($K,ASETN) $I]  
         }
      }
   }
}
