package provide TclUDF 1.0

proc UDFcfgPMEIVList {  } {
   global AllPMEIV env

# ONLY need to get the PMEIV list once so if its already been done we can 
#   exit the routine
                                                                                
   if [info exists AllPMEIV] { return }

# IF they haven't already be set, get the pertinent paths from DB.cfg

   UDFcfgPaths

# OPEN the PROJECTS.cfg file

   set PR [file join $env(UDF_HOME) config PROJECTS.cfg]
   if [catch {open $PR r} fPR] {
      puts stderr "CANNOT OPEN $PR"
      exit
   }
 
# READ the first line in the PROJECTS file until you find the Project
#   list.  Then store those in the global PMEIV list

   set Line [UDFcfgSkipLine $fPR]
   regexp {([A-Za-z]*)(.*)} $Line M hdr Rest
   while {[string match "Strings*" $hdr] == 0 } {
      set Line [UDFcfgSkipLine $fPR]
      regexp {([A-Za-z]*)(.*)} $Line M hdr Rest
   }
   set AllPMEIV [UDFcfgPMEIV $fPR $Line $Rest]

# OK parse throught the rest of the PROJECTS file storing away all of the
#   individual string definitions.  The second while just looks through
#   each returned line to see if there is a Strings identifier at the
#   end of the leading entry.  

   set Line [UDFcfgSkipLine $fPR]
   while {[string length $Line] > 0 } {
      set J  0
      regexp "(\[^\.\t \]*).(.*)" $Line M V1 Rest
      while {[string match "Strings*" $V1] == 0 } {
         if { $J == 0 } { 
            set Nm $V1
         } else {
            append Nm ".$V1"
         }
         incr J
         regexp "(\[^\.\t \]*).(.*)" $Rest M V1 Rest
      }

      global [set Nm]
      set [set Nm] [UDFcfgPMEIV $fPR $Line $Rest]
      set Line [UDFcfgSkipLine $fPR]
   }

# DONE - close the file

   close $fPR
}
