# BREAK down a  line in the PROJECTS file to give a list of all of the
#   string entries on that line

package provide TclUDF 1.0

proc UDFcfgPMEIV { FS Line Rest} {

   regexp {[^A-Za-z_0-9-]*([A-Za-z_0-9-]*)(.*)} $Rest M V Rest
   while {[string length $V] > 0 } {
      lappend NLIST $V
      regexp {[^A-Za-z_0-9-]*([A-Za-z_0-9-]*)(.*)} $Rest M V Rest
   }

   while {[string match {*\\} $Line] == 1 } {
      set Line [UDFcfgSkipLine $FS]
      regexp {[^A-Za-z_0-9-]*([A-Za-z_0-9-]*)(.*)} $Line M V Rest
      while {[string length $V] > 0 } {
         lappend NLIST $V
         regexp {[^A-Za-z_0-9-]*([A-Za-z_0-9-]*)(.*)} $Rest M V Rest
      }
   }

   return $NLIST
}
