# THIS procedure is used to scale raw data.  The method of scaling the data
#   is always the same but there are several output formats which are permitted.
#
# INPUTS: 
#   Sca   - the array of scaling values
#   Var   - the array of unscaled values
#   Fmt   - the output format 
#           FMT    OUTPUT 
#           ---    ------
#            0      list 
#            1      array
#            2      binary
#   Beg   - where to start entering values in the output list or array
#
# OUTPUT: 
#   Out   - the scaled value(s)


package provide TclUDF 1.0

proc UDFScale { Sca Var Out Fmt { Beg 0 } {TOff ""} } {

# SET up some proxy variables for the input and output arrays

   upvar $Sca Sc
   upvar $Var V
   upvar $Out X

   set VLen [array size V]
   set SLen [array size Sc]
   set I $Beg


   switch -exact -- $Fmt {
      0  {  set CmD { lappend X [expr $V($J) * $S] }                   }  
      1  {  set CmD { set X($I) [expr $V($J) * $S] }                   }  
      2  {  set CmD { append X [binary format d [expr $V($J) * $S]] }  }
   }

   if { $SLen == 1 } {
      set S  [expr pow(10.0, $Sc(0))]
      for {set J 0} {$J < $VLen} { incr J ; incr I } { eval $CmD }
   } elseif { $SLen == $VLen } {
      for {set J 0} {$J < $VLen} { incr J ; incr I } {
        set S  [expr pow(10.0, $Sc($J))]
        eval $CmD
      }
   } else {
      set End [llength $TOff]
      set TList ""
      for {set J 0} {$J < $End} { incr J } {
         lappend TList "[lindex $TOff $J] $Sc($J)"
      }
      set OList [lsort -integer -increasing -index 0 $TList]

      set LastStart [lindex [lindex $OList 0] 0]
      set TList ""
      lappend TList [lindex $OList 0]
      for {set J 1} {$J < $End} { incr J } {
         set NextStart [lindex [lindex $OList $J] 0]
         if { $NextStart != $LastStart } {
            lappend TList [lindex $OList $J]
            set LastStart $NextStart
         }
      }
      unset OList

      set End [llength $TList]
      set End1 [expr [llength $TList] -1]
      for {set I 0} {$I < $End} { incr I } {
         set Start [lindex [lindex $TList $I] 0]
         if { $I < $End1 } {
            set Stop [lindex [lindex $TList [expr $I + 1]] 0]
         } else { set Stop $VLen }
         set S [expr pow(10.0, [lindex [lindex $TList $I] 1])]
         for {set J $Start} {$J < $Stop} { incr J } { eval $CmD }
      }
   }
}
