# All Initializations

package provide TclUDF 1.0

proc UDFInits { { VPr NONE } } {
   global UDFPaths ByTe_2 ByTe_4 tcl_platform \
          VFields VDeps VSize OutSideMin OutSideMax \
          ToRad env SInfo PromoteIf fddb UDFdataOrder

#  if ![info exists fddb] { set fddb [open UDFDEBUG w] }

   set UDFPaths(0) ""
   set UDFPaths(1) ""
   set UDFPaths(2) ""
   
   if [info exists env(UDFPROMOTE)] { 
       set SInfo(AutoPr) $env(UDFPROMOTE)
   } else { set SInfo(AutoPr) OFF }

   TUreadUDFrc UDF askANS

# CHECK to see what byteOrder to use when adding data to the database

   if ![info exists askANS(Data)] { 
       set UDFdataOrder $tcl_platform(byteOrder) 
   } else { set UDFdataOrder $askANS(Data) } 

# SEE how often the VIDF file should be updated.  This is Always, Never,
#   or some number of days since the last insert.

   set PromoteIf(VIDFPr) 365000
   if [string match NONE $VPr] {
      if [info exists askANS(VIDFPr)] { 
         if [string match Never $askANS(VIDFPr)] {
            set PromoteIf(VIDFPr) 365000
         } elseif [string match Always $askANS(VIDFPr)] {
            set PromoteIf(VIDFPr) 0
         } else { set PromoteIf(VIDFPr) $askANS(VIDFPr) }
      }	  
   } else {
      if [string match Never $VPr] {
         set PromoteIf(VIDFPr) 365000
      } elseif [string match Always $VPr] {
         set PromoteIf(VIDFPr) 0
      } else { set PromoteIf(VIDFPr) $VPr }
   } 

   if [string match littleEndian $UDFdataOrder] {
      set ByTe_2 s
      set ByTe_4 i
   } else {
      set ByTe_2 S
      set ByTe_4 I
   }

   set OutSideMin -3.4e38
   set OutSideMax  3.4e38
   set ToRad [expr acos(-1.0) / 180.0 ] 

#  THE VIDF fields information

   UDFvidfInfo

# PROMOTE inits

   set PromoteIf(IMAGE)       7200000
   set PromoteIf(GEOSOLARIND) 7200000
   set PromoteIf(CLUSTERII)    600000
   set PromoteIf(ISTP)         600000

# GET the UDF configuration information

  UDFcfgPMEIVList
}
