#   This is the UDF float to native float conversion routine  
#
#  FmT Definitions
#    2   Single Precicion 1 (32 bits)
#    3   Double Precicion 1 (64 bits) (undefined UDF format)
#    4   Half Precision 1   (16 bits)
#    5   Half Precision 2   (16 bits) [CLUSTER PEACE MOMENTS]
#    6   Half Precision 3   (16 bits) [INTERBALL SCA]
#    7   Single Precision 2 (32 bits) [IMAGE (IEEE?)]
#
#  Variable Definitions
#    MSgn   Sn of the Mantissa
#    MMag   Magnitude of the Mantissa
#    ESgn   Sn of the Exponent
#    EMag   Magnitude of the Exponent
#    S      Exponent modifier
#    E      Base to use when applyng exponent 
#    N      Any normalization factor which needs be applied to the result
#
#  Special Definitions 
#
#   If both mantissa and exponent are 0 then 
#      MSgn=0, ESgn=0: value is 0.0
#      MSgn=1, ESgn=0: value is +infinity
#      MSgn=1, ESgn=1: value is -infinity
#      MSgn=0, ESgn=1: value is invalid
#

package provide TclUDF_C 1.0
#package provide TclUDF 1.0

proc UDFFloat { Data Len FmT } {

   upvar $Data V

   switch -exact -- $FmT {
      2  {   set S 7.0
             set E 10.0
             for {set I 0} {$I < $Len} {incr I } { 
               set MSgn [expr ($V($I) >> 31) & 0x00000001]
               set MMag [expr ($V($I) >> 7) & 0x00ffffff ]
               set ESgn [expr ($V($I) >> 6) & 0x00000001 ]
               set EMag [expr $V($I) & 0x0000003f ]
               if {($MMag == 0) && ($EMag == 0) } { 
                  if {($MSgn == 0) && ($ESgn == 0) } {
                     set V($I)  0.0
                  } elseif { ($MSgn == 1) && ($ESgn == 0) } {
                     set V($I)  3.402823e38
                  } elseif { ($MSgn == 1) && ($ESgn == 1) } { 
                     set V($I)  -3.402823e38
                  } else { set V($I) 0.0 }
               } else {
                  if { $MSgn == 1 } { set MMag [expr -$MMag ] }
                  if { $ESgn == 1 } { set EMag [expr -$EMag ] }
                  set V($I) [expr $MMag * pow ($E, [expr $EMag - $S] )]
               }
            }
         }
      3  {  for {set I 0} {$I < $Len} {incr I } { 
                 set V($I) 0.0 
            }
         }
      4  {   set S 2.0
             set E 10.0
             for {set I 0} {$I < $Len} {incr I } { 
               set MSgn [expr ($V(I) >> 15) & 0x00000001]
               set MMag [expr ($V(I) >> 7) & 0x000000ff ]
               set ESgn [expr ($V(I) >> 6) & 0x00000001 ]
               set EMag [expr $V(I) & 0x0000003f ]
               if {($MMag == 0) && ($EMag == 0) } { 
                  if {($MSgn == 0) && ($ESgn == 0) } {
                     set V($I)  0.0
                  } elseif { ($MSgn == 1) && ($ESgn == 0) } {
                     set V($I)  3.402823e38;
                  } elseif { ($MSgn == 1) && ($ESgn == 1) } { 
                     set V($I)  -3.402823e38;
                  } else { set V($I) 0.0 }
               } else {
                  if { $MSgn == 1 } { set MMag [expr -$MMag ] }
                  if { $ESgn == 1 } { set EMag [expr -$EMag ] }
                  set V($I) [expr $MMag * pow ($E, [expr $EMag - $S] )]
               }
            }
         }
      5  {   set S 128.0
             set E 2.0
             set N 256.0
             set ESgn 0
             for {set I 0} {$I < $Len} {incr I } { 
               if { $V(I) != 0 } { 
                  set MMag [expr (($V(I) >> 8) & 0x0000007f) + 128 ]
               } else { set MMag 0 }
               set MSgn [expr ($V(I) >> 15) & 0x00000001 ]
               set EMag [expr $V(I) & 0x000000ff ]
               if {($MMag == 0) && ($EMag == 0) } { 
                  if {($MSgn == 0) && ($ESgn == 0) } {
                     set V($I)  0.0
                  } elseif { ($MSgn == 1) && ($ESgn == 0) } {
                     set V($I)  3.402823e38;
                  } elseif { ($MSgn == 1) && ($ESgn == 1) } { 
                     set V($I)  -3.402823e38;
                  } else { set V($I) 0.0 }
               } else {
                  if { $MSgn == 1 } { set MMag [expr -$MMag ] }
                  set V($I) [expr $MMag * pow ($E, [expr $EMag - $S]) / $N]
               }
            }
         }
      6  {   set E 2.0
             for {set I 0} {$I < $Len} {incr I } { 
               set B1 [expr ($V >> 8) & 0x000000ff]
               set B2 [expr $V & 0x000000ff 
               set ESgn [expr ($B1 >> 7) & 0x01 ]
               set EMag [expr $B1 & 0x3f ]
               set MSgn [expr ($B1 >> 6) & 0x01 ]
               if { $EMag != 0 } { 
                  set MMag [expr $B2 + 256 ]
                  set N 512.0
               } else { 
                  set MMag $B2 
                  set N 1.0
               }
               if {($MMag == 0) && ($EMag == 0) } { 
                  if {($MSgn == 0) && ($ESgn == 0) } {
                     set V($I)  0.0
                  } elseif { ($MSgn == 1) && ($ESgn == 0) } {
                     set V($I)  3.402823e38;
                  } elseif { ($MSgn == 1) && ($ESgn == 1) } { 
                     set V($I)  -3.402823e38;
                  } else { set V($I) 0.0 }
               } else {
                  if { $MSgn == 1 } { set MMag [expr -$MMag ] }
                  set V($I) [expr $MMag * pow ($E, $EMag]) / $N]
               }
            }
         }
      7  {   set E 2.0
             set S 127.0
             set N [expr 1 << 23 ]
             for {set I 0} {$I < $Len} {incr I } { 
                set MSgn [expr ($V($I) >> 31) & 0x00000001]
                set MMag [expr $V($I) & 0x07fffff ]
                set EMag [expr ($V($I) >> 23) & 255]
                if { $EMag == 255 } {
                   set EMag 0
                   set MSgn 1
                   if {$MMag == 0} { set ESgn 0 } else { set ESgn 1 }
                   set MMag 0
                } else { 
                   set ESgn 0 
                   set MMag [expr $MMag | 0x0800000 ]
                }
                if {($MMag == 0) && ($EMag == 0) } { 
                  if {($MSgn == 0) && ($ESgn == 0) } {
                     set V($I)  0.0
                  } elseif { ($MSgn == 1) && ($ESgn == 0) } {
                     set V($I)  3.402823e38;
                  } elseif { ($MSgn == 1) && ($ESgn == 1) } { 
                     set V($I)  -3.402823e38;
                  } else { set V($I) 0.0 }
               } else {
                  if { $MSgn == 1 } { set MMag [expr -$MMag ] }
                  set V($I) [expr $MMag * pow ($E, [expr $EMag - $S]) / $N]
               }
            }
         }
   }
}
