package provide TclUDF 1.0

proc ToThisTime { Key Ver Yr Dy Hr Mn Ss {SType COARSE}} {
   global SInfo ByTe_4 ByTe_2 ExDa

   set B $Key,$Ver
   set G $Key,$Ver,GN
   set S $Key,$Ver,SS

# CONVERT UT to milliseconds and then form the current time string

   set Ms [expr int($Hr * 3600000 + $Mn * 60000 + $Ss * 1000)] 
   set cTm [format "%4d%03d%08d" $Yr $Dy $Ms]
   
#  FIRST we need to see if we are just moving around in the current file or
#    do we need to open another file and go from there.

   set rV [UDFfileFirst $B $Yr $Dy $Hr $Mn $Ss ]
   if {[string match ERROR: $rV] } { return 0|NOFIND }
   if { $rV == 0 } { return 1 }

   set fd $SInfo($B,DFD)
   set fh $SInfo($B,HFD)
   fconfigure $fd -translation binary
   fconfigure $fh -translation binary

#  NOW DO A QUICK BINARY SEARCH TO THE DATA RECORD WHICH CONTAINS THE
#  START TIME

   set Fname [file join $SInfo($B,IHDPATH) \
                  [lindex [lindex $SInfo($B,HDLIST) $SInfo($B,HDNUM)] 0]D]
   set FLen [file size $Fname]
   set NumRec [expr int($FLen / $SInfo($G,DLEN))]
   set Low 0
   set High [expr $NumRec - 2]
   set FirstTime 1
   set Nsec 0
   while {$Low <= $High} {
      set Mid [expr int(($Low + $High)/2)]
      set Bytes [expr $SInfo($G,DLEN) * $Mid]
      UDFreadDATA $B $Bytes
      UDFreadHDR $B 0
      UDFretVar $B YRDY yD
      UDFretVar $B TIME Tm
      set fTm [format "%4d%03d%08d" [lindex $yD 0] [lindex $yD 1] $Tm]
      set tList [lsort -ascii -increasing [list $fTm $cTm]]
      set Pos [lsearch -exact $tList $cTm]
      if {$Pos == 0 } { 
         if ![string match $fTm $cTm] {
            set High [expr $Mid - 1] 
        } else { set High -10 }
      } else { set Low [expr $Mid + 1] } 
   }

#  DO THE FINAL ADJUSTMENT TO GET TO THE START OF THE RECORD
#  THIS CONSISTS OF READING THE NEXT RECORD AND MAKING SURE THE
#  REQUESTED TIME IS BETWEEN THE CURRENT AND NEXT RECORD TIMES.
#  IF NOT - SEARCH A BIT FORWARD OR BACKWARD

   set Done 0
   set lTm [format "%4d%03d%08d" [lindex $yD 0] [lindex $yD 1] $Tm]
   while { $Done == 0 } {
      if { [UDFreadDATA $B -1] == 0 } {
         UDFreadHDR $B 0
         UDFretVar $B YRDY yD
         UDFretVar $B TIME Tm
         set nTm [format "%4d%03d%08d" [lindex $yD 0] [lindex $yD 1] $Tm]
         set tList [lsort -ascii -increasing [list $lTm $cTm $nTm]]
         set Pos [lsearch -exact $tList $cTm]
         switch -exact -- $Pos {
             0 {   set Cen [lindex $tList 1]
                   if ![string match $cTm $Cen] {
                      set Bytes [expr -3 * $SInfo($G,DLEN)]
                      if { [TUfileSeek $fd $Bytes current] >= 0 } {
                         UDFreadDATA $B -1
                         UDFreadHDR $B 0
                         UDFretVar $B YRDY yD
                         UDFretVar $B TIME Tm
                         set lTm [format "%4d%03d%08d" [lindex $yD 0] \
                                                       [lindex $yD 1] $Tm]
                         incr Mid -1
                      } else { set Done 1 }
                   } else { set Done 1 }
                }
             1  {  incr Mid
	           set Done 1
                }
             2  {  incr Mid
                   set lTm $nTm
                }
         }
      } else { set Done 1 }
   }

   set Bytes [expr $Mid * $SInfo($G,DLEN)]
   set rV [UDFreadDATA $B $Bytes]
   TUfileSeek $fd $Bytes start
   UDFreadHDR $B 0

#
#  Initialize some of the read variables here
#

   UDFvarInits $B 1
   UDFretVar $B YRDY yD
   UDFretVar $B TIME Tm

   if {[string match FINE $SType] == 1 } {
       set Done 0
       set N T
       while { $Done == 0 } {
          ReadUDF $Key $Ver $N -1 0 0 0 
          set lTm [format "%4d%03d%08d" $ExDa($N,BYR) $ExDa($N,BDY) \
                                        $ExDa($N,BMSEC) ]
          set nTm [format "%4d%03d%08d" $ExDa($N,EYR) $ExDa($N,EDY) \
                                        $ExDa($N,EMSEC) ]
          set tList [lsort -ascii -increasing [list $lTm $cTm $nTm]]
          set Pos [lsearch -exact $tList $cTm]
          if {$Pos == 2 } {
             set SInfo($Key,$Ver,RSTATUS) 1
          } else { set Done 1 }
       }
       UDFunsetExDa T
   }
   set SInfo($Key,$Ver,RSTATUS) -1
}
