# THIS is the basic UDF read program.  It reads data from a UDF/IDFS data
#   file and returns it in a set of arrays.
#
# INPUTS
#    Key     - UDF Key of data to read
#    Ver     - Version number used in open
#    N       - Array ID in which to store the data
#    SeN     - VIDF Sensor number of data to return.  All anciallay, mode, and
#              array index data associated with this sensor is automatically
#              returned with the data
#    CoL     - It this is matrix data what column in the matrix to return.  A
#              full matrix of data cannot be returned only one column at a time
#    FwD     - Move the file pointer forward after the read
#    FullSwp - Read a full column of data.  This is default for Array and
#              Matrix data but not for scalar data so it can be made so
#              with this inpput flag

package provide TclUDF 1.0

proc ReadUDF { Key Ver N SeN CoL FwD { FullSwp 0} } {
   global SInfo ExDa ExData$N ExAnc$N ExMode$N ExScan$N

   set B $Key,$Ver
   set G $Key,$Ver,GN
   set S $Key,$Ver,SS
  
   set ExDa($N,GOTDATA) 0
   set ExDa($N,SEN) $SeN
   set ExDa($N,COL) $CoL
   set ExDa($N,FULLSWP) $FullSwp

   set SInfo($B,HSTATUS) 0

# CHECK the file status to make sure its open and ready to go

   if { $SInfo($B,FSTATUS) < 0 } { return "-2|ReadUDF - UNOPENED FILES" }

# CHECK the read status.  Advance to next sample if we have to

if { $SInfo($B,RSTATUS) == 1 } { 
      if { [UDFtimeNext $B $N] < 0 } { return "-1|EOF" }
   }

#  DO some pre-checks if this is a matrix sensor

   if { $SInfo($G,SMPID) == 3 } {
      UDFretVar $B COLDATA CInfo 1
      if {$CoL > $CInfo(2) } { return "0|Read_UDF - NO SENSOR" }
      set RelCol [expr $CoL - $CInfo(1)]
      while { ($RelCol < 0) || ($RelCol >= $CInfo(0)) } {
         UDFtimeNext $B $N  
         if { $SInfo($B,HSTATUS) == 1 } {
            UDFretVar $B COLDATA CInfo 1
         }
         if {$CoL > $CInfo(2) } { return "0|Read_UDF - NO SENSOR" }
         set RelCol [expr $CoL - $Cinfo(1)]
      } 

      set ExDa($N,TOTCOLS) $CInfo(2)
   } else { set ExDa($N,TOTCOLS) 1 }

#  LOOP through the returned sensors and determint if the requested 
#     measurement is being returned in this sensor set.  If it is find
#     its position in the header sensor array.


   set GotSensor -1
   UDFretVar $B SENS SenS 1
   if { $SeN < 0 } { set SeN $SenS(0) ; set ExDa($N,SEN) $SeN }
   set Len [array size SenS]
   set SenPos 0
   while { ($GotSensor == -1 ) && ($SenPos < $Len ) } {
      if {$SeN == $SenS($SenPos) } {
         set GotSensor 1
#        if {$SInfo($G,ROWTIME) == 1} {
#           if {($SInfo($G,SMPID) != 3) && ($SenPos != $SInfo($S,TMCOL)) } {
#              set GotSensor 0
#           }
#        }
      } else { incr SenPos }
   }

   if {$GotSensor == -1 } { 
      UDFtimeSet $B $N
      set SInfo($B,RSTATUS) $FwD
      return "0|Read_UDF - NO SENSOR" 
   }

#
#  Load up any scan indices associated with the measurement and any mode
#  data.
#

   UDFretVar $B TIME ExDa($N,TIME)
   UDFretVar $B SPIN ExDa($N,SPIN)
   UDFretVar $B ZERO ExDa($N,ZERO)
   UDFretVar $B NMODES ExDa($N,NMODE)
   UDFretVar $B SCAN ExScan$N 1
   UDFretVar $B MODES ExMode$N 1

#  Set Times

   UDFtimeSet $B $N
   UDFdataSen $B $N $SenPos

   UDFdataPhi $B $N 
   UDFdataAnc $B $N $SenPos

   UDFretVar $B QUAL qV 1
   set ExDa($N,QuaL) $qV($SenPos)
   set SInfo($B,RSTATUS) $FwD

   return "1|ALLOK"
}
