# Gets the starting PIDF, VIDF, and UDF files

package provide TclUDF 1.0

proc FileOpen { Key Ver Yb Db Hb Mb Sb Ye De He Me Se {pChk 1} {vOnly 0} } {
   global UDFPaths SInfo
   
# Get Sources from the Key and then determine the directory paths

   set Src [split [UDFinvKey $Key]]
   UDFdirPaths [lindex $Src 0] [lindex $Src 1] [lindex $Src 2] [lindex $Src 3]

# Convert Input Hours, Minutes, and Seconds to Milliseconds

   set Msb [expr int($Hb * 3600000 + $Mb * 60000 + $Sb * 1000)] 
   set Mse [expr int($He * 3600000 + $Me * 60000 + $Se * 1000)] 

# CHECK that all files needed are present.  This is done only once per open
#   per UDF data set/version combination

   set kV $Key,$Ver
   if { (![info exist SInfo($kV,PCHK)]) && ($pChk != 0) } { 
      UDFchkPromote SEARCHV $Key $Yb $Db $Msb $Ye $De $Mse
      if { !$vOnly } { UDFchkPromote SEARCH  $Key $Yb $Db $Msb $Ye $De $Mse }
      set SInfo($kV,PCHK) 1
   }

# Get the I files corresponding to the time period 

   set List [DBgetEntries $Key $Yb $Db $Msb $Ye $De $Mse I]
   set SInfo($kV,VLIST) [lsort -ascii -increasing -index 0 $List]

# Get the HD files corresponding to the time period 

   if { !$vOnly } {
      set List [DBgetEntries $Key $Yb $Db $Msb $Ye $De $Mse HD]
      set SInfo($kV,HDLIST) [lsort -ascii -increasing -index 0 $List]

# Get the pointer to the PIDF file

      set SInfo($kV,PLIST) [lindex $Src 4].pidf.v2  
   }

   set SInfo($kV,PPATH) $UDFPaths(0)
   set SInfo($kV,IHDPATH) $UDFPaths(2)

   UDFvarInits $kV 0
   set SInfo($kV,FSTATUS) [UDFfileOpen $kV $vOnly] 

   if { $SInfo($kV,FSTATUS) == 1 } { UDFvidfVals $kV }
}
