/*  The C equivalent of UDFUnsign,  It consists of a TCL interface over     */
/*  a straight C subroutine                                                 */
/*                                                                          */
/*  There are 3 OBJV elements.  These are:                                  */
/*     OBJV[0]:  Routine name                                               */
/*     OBJV[1]:  Data bit length                                            */
/*     OBJV[2]:  Elements in data array                                     */
/*     OBJV[3]:  The input/output data array                                */
/*     OBJV[4]:  Start location in data array (OPTIONAL)                    */

#include <tcl.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "ByteDefs.h"
#include "TudfAnsi.h"
#include "TutilAnsi.h"

int ToUnsign (ClientData cD, Tcl_Interp *tI, int objc, Tcl_Obj *CONST *objv) 
{
   void   *memPtr = NULL; 
   ByTe_4 Bytes, nE;
   int    N, BeG = 0, Bits;
  
/* MAKE sure that all the IO parameters are present                      */

   if (objc < 4 ) {
     Tcl_WrongNumArgs(tI, 1, objv, "Usage: UDFFloat X N Fmt");
     return TCL_ERROR;
   }

/* GET the inputs - this routine only works on data of integral byte     */
/*    length.                                                            */
 
   Tcl_GetIntFromObj (tI, objv[1], &Bits);
   if ((Bits % 8) != 0 ) { return TCL_OK; }
   Tcl_GetIntFromObj (tI, objv[2], &N);
   if (objc > 4 ) { Tcl_GetIntFromObj (tI, objv[4], &BeG); }

/* GET the work array memory and put the input data into it              */

   Bytes = sizeof(ReaL_8) * N;
   if ((memPtr = malloc (Bytes)) == NULL) { return TCL_ERROR; }

   if ((nE = TclArrayToC (tI, objv[3], memPtr, N, (ByTe_4)BeG, 'L')) == 0) {
      free (memPtr);
      return TCL_OK;
   }   

/* CALL the C routine                                                    */

   ToUnsign_C (memPtr, nE, Bits);

/* PUT the data back into the data array                                 */

   CArrayToTcl (tI, objv[3], memPtr, nE, (ByTe_4)BeG, 'D'); 

/* GET rid of the temporary array and return                             */

   free (memPtr);
   return TCL_OK;

}

void ToUnsign_C (void *Data, int nE, int Bits) 
{
   register ReaL_8 *X;
   register ByTe_4 I, V;
   u_ByTe_4 Max;

   X = (ReaL_8 *)Data;

   Max = 1 << Bits;

   for ( I = 0; I < nE;  ++I, ++X ) { 
      V = (ByTe_4)*X;
      if (V < 0) { *X = (ReaL_8)(Max + V); }
   }
}
