/*  The C equivalent of UDFtimeData,  It consists of a TCL interface over   */
/*  a straight C subroutine                                                 */
/*                                                                          */
/*  There are 5 OBJV elements - last two optional.  These are:              */
/*     OBJV[0]:  Routine name                                               */
/*     OBJV[1]:  UDF data key/version combination (kV)                      */
/*     OBJV[2]:  The UDF data structure indicator (N)                       */
/*     OBJV[3]:  TmRow                                                      */
/*     OBJV[4]:  TmCol                                                      */

#include <tcl.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "ByteDefs.h"
#include "TutilAnsi.h"
#include "TudfAnsi.h"

int TimeData (ClientData cD, Tcl_Interp *tI, int objc, Tcl_Obj *CONST *objv) 
{
   int    Len;
   ByTe_1 *kV, *N, OuT[256];
   ByTe_4 iV[20], rV[10];

   Tcl_Obj *rVO;

/* MAKE sure that all the IO parameters are present                         */

   if (objc < 3 ) {
     Tcl_WrongNumArgs(tI, 1, objv, "Usage: UDFdataPhi kV N" );
     return TCL_ERROR;
   }

/* GET required the inputs                                                  */
 
   kV = Tcl_GetStringFromObj (objv[1], &Len);
   N  = Tcl_GetStringFromObj (objv[2], &Len);

/* CHECK for the optional inputs                                            */

   iV[12] = -1;
   iV[13] = -1;
   if (objc >= 4 ) { 
      Tcl_GetIntFromObj (tI, objv[3], &iV[12]); 
   } else { CGetVar (tI, "SInfo", kV, ",SS,TMROW", 'L', (ByTe_1 *)&iV[12]); }
   if (objc >= 5 ) { 
      Tcl_GetIntFromObj (tI, objv[4], &iV[13]);
   } else { CGetVar (tI, "SInfo", kV, ",SS,TMCOL", 'L', (ByTe_1 *)&iV[13]); }


/*  GET the basic internal variables needed                                 */

   BlockVar (tI, 1, kV, "", (u_ByTe_1 **)NULL, (ByTe_1 *)iV, 0, (Tcl_Obj *)NULL);
   BlockVar (tI, 2, kV, "", (u_ByTe_1 **)NULL, (ByTe_1 *)iV, 8, (Tcl_Obj *)NULL);
   CGetVar (tI, "ExDa", N, ",FULLSWP", 'L', (ByTe_1 *)&iV[16]);

/* Call the C routine                                                       */

   TimeData_C (tI, kV, N, iV, rV);

   sprintf (OuT, "%d %d %d %d %d %d", rV[0], rV[1], rV[2], rV[3], rV[4], rV[5]);
   rVO = Tcl_GetObjResult(tI);
   Tcl_SetStringObj (rVO, OuT, strlen(OuT));

   return TCL_OK;
}

/* THE C ROUTINE                                                            */


ByTe_4 TimeData_C (Tcl_Interp *tI, ByTe_1 *kV, ByTe_1 *N, ByTe_4 *iV, 
                    ByTe_4 *rV)
{
   int    Len, Off;

   ByTe_2   NsmP;
   u_ByTe_2 *Sc;

   ByTe_4   CoL, SenN, TcP, ERoW, TmP;
   ByTe_4   TmOff;
   ByTe_4   End;

   u_ByTe_1 *cP[2];

/* GET pointers to the header and data records                             */

   BlockVar (tI, 0, kV, "", cP, (ByTe_1 *)NULL, 0, (Tcl_Obj *)NULL);

/* GET the number of samples returned with a sensor                        */

   NsmP = *(u_ByTe_2 *)(cP[0] + 24);

/* GET some of the stored information                                      */

   CGetVar (tI, "ExDa", N, ",SEN", 'L', (ByTe_1 *)&SenN);

/* IF this is a matrix sensor then we need to modify TmCoL to reflect the  */
/*    the current relative matrix column number.                           */

   if ( iV[8] == 3 ) {
      TmP = *(u_ByTe_2 *)(cP[0] + 28);
      CGetVar (tI, "ExDa", N, ",COL", 'L', (ByTe_1 *)&CoL);
      iV[13] += CoL - TmP; 
   }

/* GET the start time of the current measurement using all of the          */
/*    timing elements.  TIME and TIME_OFF are not used in the nanoseconds  */
/*    workup since they are returned in milliseconds only                  */

   CGetListVar(tI, "SInfo", kV, ",GN,TIMEOFF", SenN, -1,  'L', (ByTe_1 *)&TmOff);
   TmP = *(u_ByTe_4 *)cP[1];
   rV[2] = TmP + TmOff + iV[0] + iV[12] * iV[6] + iV[13] * iV[4];
   rV[3] = iV[1] + iV[12] * iV[7] + iV[13] * iV[5];

/* CORRECT for negative time                                              */

   if (rV[2] < 0) {
      rV[0] = 1;
      rV[2] += 86400000;
   } else { rV[0] = 0; } 

   rV[2] += (ByTe_4)(rV[3] / 1000000);
   rV[3] = rV[3] % 1000000;

/*  OK - we got the beginning time - now get the ending time.  This is    */
/*    a  bit more complicated.                                            */
/*                                                                        */
/*    If the sensor set columns are parallel then all that needs to be    */
/*    done is to increment the start time by the sample time, otherwise   */
/*    we need to know the effective ending row of the samples being       */
/*    returned. This depends on if the data is scalar or array and if its */
/*    an array on the DAMETHOD set for the data.                          */

   TcP = 1 - iV[9] % 2;
   if (TcP == 0) {
      rV[4] = rV[2] + iV[2];
      rV[5] = rV[3] + iV[3];
   } else {
      ERoW = 1;
      if (iV[8] == 2) {
         if (iV[16] == 1) { ERoW = NsmP - iV[12]; }
         ERoW = (ERoW == 1) ? iV[12] + 1 : NsmP;
      } else {
         Len = (iV[8] == 2) ? 1 : NsmP;
         CGetVar (tI, "SInfo", kV, ",PT,TOSCAN", 'L', (ByTe_1 *)&Off);
         Sc = (u_ByTe_2 *)(cP[0] + Off);
         switch (iV[10]) {
            case 0:
               ERoW = NsmP;
            break;
            case 1:
               ERoW = iV[11];
            break;
            case 3:
               if (NsmP != 1) { ERoW = abs(Sc[1] - Sc[0]) * NsmP; }
            break;
            default:
               End = NsmP - 1;
               ERoW = abs(Sc[End] - Sc[0]);
            break;
         }
      }
      rV[4] = TmP + TmOff + iV[0] + ERoW * iV[6] + iV[13] * iV[4];
      rV[5] = iV[1] + ERoW * iV[7] + iV[13] * iV[5];
   }

/* CORRECT for negative time                                              */

   if (rV[4] < 0) {
      rV[1] = 1;
      rV[4] += 86400000;
   } else { rV[1] = 0; } 
   rV[4] += (ByTe_4)(rV[5] / 1000000);
   rV[5] = rV[5] % 1000000;

   return 1;
}
