#include <tcl.h>

int DataFill (ClientData clientData, Tcl_Interp *interp, 
               int objc, Tcl_Obj *CONST *objv); 
int DoMath (ClientData clientData, Tcl_Interp *interp, 
               int objc, Tcl_Obj *CONST *objv); 
int FillPhi (ClientData clientData, Tcl_Interp *interp, 
               int objc, Tcl_Obj *CONST *objv); 
int FillSen (ClientData clientData, Tcl_Interp *interp, 
               int objc, Tcl_Obj *CONST *objv); 
int RetVar (ClientData clientData, Tcl_Interp *interp, 
               int objc, Tcl_Obj *CONST *objv); 
int TblApply (ClientData clientData, Tcl_Interp *interp, 
               int objc, Tcl_Obj *CONST *objv); 
int TimeComps (ClientData clientData, Tcl_Interp *interp, 
               int objc, Tcl_Obj *CONST *objv); 
int TimeData (ClientData clientData, Tcl_Interp *interp, 
               int objc, Tcl_Obj *CONST *objv); 
int ToFloat (ClientData clientData, Tcl_Interp *interp, 
               int objc, Tcl_Obj *CONST *objv); 
int ToUnsign (ClientData clientData, Tcl_Interp *interp, 
               int objc, Tcl_Obj *CONST *objv); 

int Tcludf_Init (Tcl_Interp *interp) {
   Tcl_CreateObjCommand (interp, "UDFdataFill", DataFill, 
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
   Tcl_CreateObjCommand (interp, "UDFMath", DoMath, 
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
   Tcl_CreateObjCommand (interp, "UDFdataPhi", FillPhi, 
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
   Tcl_CreateObjCommand (interp, "UDFdataSen", FillSen, 
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
   Tcl_CreateObjCommand (interp, "UDFretVar", RetVar, 
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
   Tcl_CreateObjCommand (interp, "UDFtblApply", TblApply, 
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
   Tcl_CreateObjCommand (interp, "UDFtimeComps", TimeComps, 
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
   Tcl_CreateObjCommand (interp, "UDFtimeData", TimeData, 
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
   Tcl_CreateObjCommand (interp, "UDFFloat", ToFloat, 
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
   Tcl_CreateObjCommand (interp, "UDFUnsign", ToUnsign, 
                       (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);

   Tcl_PkgProvide(interp, "TclUDF_C",  "2.0");

   return TCL_OK;
}
