/*  The C equivalent of UDFtblApply,  It consists of a TCL interface over   */
/*  a straight C subroutine                                                 */
/*                                                                          */
/*  There are 6 OBJV elements.  These are:                                  */
/*     OBJV[0]:  Routine name                                               */
/*     OBJV[1]:  UDF data key/version combination (kV)                      */
/*     OBJV[2]:  Method to use to retrieve table value                      */
/*     OBJV[3]:  Offset into table array to start of table                  */
/*     OBJV[4]:  Number of elements in the table                            */
/*     OBJV[5]:  Input value operated on by the table                       */

#include <tcl.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "ByteDefs.h"
#include "TudfAnsi.h"
#include "TutilAnsi.h"

int TblApply (ClientData cD, Tcl_Interp *tI, int objc, Tcl_Obj *CONST *objv) 
{
   ReaL_8 V, rV;
   int    Len, nE, rFmt, Off;
   int Flg = TCL_LEAVE_ERR_MSG;

   u_ByTe_1 *tP;
   ByTe_1 *kV, VarN[50];

   Tcl_Obj *tO, *aName;

/* MAKE sure that all the IO parameters are present                         */

   if (objc != 6 ) {
     Tcl_WrongNumArgs(tI, 1, objv, "Usage: UDFtblApply kV Op Off N V");
     return TCL_ERROR;
   }

/* GET the inputs                                                           */
 
   kV = Tcl_GetStringFromObj (objv[1], &Len);
   Tcl_GetIntFromObj (tI, objv[2], &rFmt);
   Tcl_GetIntFromObj (tI, objv[3], &Off);
   Tcl_GetIntFromObj (tI, objv[4], &nE);
   Tcl_GetDoubleFromObj (tI, objv[5], &V);

/*  GET the pointer to the table values                                    */

   sprintf(VarN, "Tbls%s", kV);
   aName  = Tcl_NewStringObj (VarN, -1);
   tO = Tcl_ObjGetVar2(tI, aName, NULL, Flg);
   tP = Tcl_GetByteArrayFromObj(tO, &Len);
   Tcl_DecrRefCount(aName);

/* CALL the C routine                                                    */

   rV =  TblApply_C (tP, (ByTe_4)rFmt, (ByTe_4)Off, (ByTe_4)nE, V);

   tO = Tcl_GetObjResult(tI);
   Tcl_SetDoubleObj (tO, rV); 

   return TCL_OK;

}

/* THE C ROUTINE                                                            */


ReaL_8 TblApply_C (u_ByTe_1 *tP, ByTe_4 tOp, ByTe_4 tOff, ByTe_4 N, ReaL_8 V) 
{
   register ReaL_8  *T, *Tend, X;
   ReaL_8   rV, dV1, dV2, Prod;
   ByTe_4   Low, Mid, High, Max;

   T = (ReaL_8 *)tP;
   T = (ReaL_8 *)tP + tOff;
   switch (tOp) {
      case 0:
         rV = *(T + (ByTe_4)V);
      break;
      case 1:
        if ( N == 1 ) {
           rV = 0;
        } else {
           dV1 = *T - *(T + 1);
           if ( N > 3 ) {
               dV1 = *(T + 1) - *(T + 2);
               Prod =  dV1 * dV2;
           } else { Prod = 1; }

           if ( Prod > 0 ) {
              Low = 0;
              High = N - 1;
              Max = High;
              if ( dV1 < 0.0 ) {
                 while ( Low <= High ) {
                    Mid = (ByTe_4)((Low + High) / 2);
                    if ( V <= *(T + Mid) ) {
                       High = Mid - 1;
                    } else { Low = Mid + 1; }
                 }
              } else {
                 while ( Low <= High ) {
                    Mid = (ByTe_4)((Low + High) / 2);
                    if ( V <= *(T + Mid) ) {
                       High = Mid + 1;
                    } else { Low = Mid - 1; }
                 }

                 if (((Low < 0) || (Low > Max)) || ((High < 0) || (High > Max))) {
                    rV = (ReaL_8)Mid;
                 } else {
                    if ( V > *(T + High) ) {
                        dV1 = V - *(T + High);
                    } else { dV1 = *(T + High) - V; }
                    if ( V > *(T + Low) ) {
                        dV2 = V - *(T + Low);
                    } else { dV1 = *(T + Low) - V; }
                    rV = (dV1 >= dV2 ) ? (ReaL_8)Low : (ReaL_8)High;
                 }
              }
           }
        }
      break;
      case 2:
         Tend = T + N;
         X = 1.0;
         rV = *T++;
         for ( ; T < Tend; ++T) {
            X *= V;
            rV += X * *T;
         }
      break;
      case 3:
         rV = V;
      break;
   }

  return rV;
}
