/*  The C equivalent of UDFdataSen.  It is a straight C subroutine          */
/*                                                                          */
/*  There are 3 OBJV elements.  These are:                                  */
/*     OBJV[0]:  Routine name                                               */
/*     OBJV[1]:  UDF data key/version combination (kV)                      */
/*     OBJV[2]:  The UDF data structure indicator (N)                       */
/*     OBJV[2]:  The sensor position in the sensor set                      */

#include <tcl.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "ByteDefs.h"
#include "TudfAnsi.h"
#include "TutilAnsi.h"

int FillSen (ClientData cD, Tcl_Interp *tI, int objc, Tcl_Obj *CONST *objv) 
{
   void   *memPtr = NULL, *vP; 
   register ReaL_8 *rPt;
   register ByTe_4 *lPt;
   register ByTe_2 *sPt;
   register ByTe_1 *cPt;

   ByTe_4 iV[20], Bytes, I;
   ByTe_4 FSwp, NsmP, SmpID, TmRow;
   ByTe_4 sCol, rCol, Off, nE;
   int    Len, sP;
   ByTe_1 *N, *kV;
   ByTe_1  VarN[50], Index[50];
   u_ByTe_1 *cP[2];
  
   int Flg = TCL_LEAVE_ERR_MSG;

   Tcl_Obj *rV1;

/* MAKE sure that all the IO parameters are present                         */

   if (objc != 4 ) {
     Tcl_WrongNumArgs(tI, 1, objv, "Usage: UDFdataSen kV N, sPos");
     return TCL_ERROR;
   }

/* GET the inputs                                                        */
 
   kV = Tcl_GetStringFromObj (objv[1], &Len);
   N  = Tcl_GetStringFromObj (objv[2], &Len);
   Tcl_GetIntFromObj (tI, objv[3], &sP);
   rV1 = Tcl_NewObj();

/* GET pointers to the header and data records                           */

   BlockVar (tI, 0, kV, "", cP, (ByTe_1 *)NULL, 0, (Tcl_Obj *)NULL);

/* GET some needed background variables                                  */

   BlockVar (tI, 5, kV, N, cP, (ByTe_1 *)iV, 0, (Tcl_Obj *)NULL);
   NsmP = *(u_ByTe_2 *)(cP[0] + 24);
   CGetVar (tI, "ExDa", N, ",FULLSWP", 'L', (ByTe_1 *)&FSwp);
   CGetVar (tI, "ExDa", N, ",COL", 'L', (ByTe_1 *)&rCol);
   CGetVar (tI, "SInfo", kV, ",GN,SMPID", 'L', (ByTe_1 *)&SmpID);
   CGetVar (tI, "SInfo", kV, ",SS,TMROW", 'L', (ByTe_1 *)&TmRow);

/* COMPUTE the number of elemets to return                               */

   nE = ((SmpID == 2) && (FSwp == 0)) ? 1 : NsmP - TmRow;

/* DETERMINE the sensor column                                           */

   if (SmpID == 3) {
      sPt = (ByTe_2 *)(cP[0] + 26);
      sCol = sP * *sPt + rCol - *(sPt + 1);
   } else { sCol = sP; }

/* COMPUTE the offset to the data.  Set a void pointer to that location. */
/*    Later we'll determine what format to use to retrieve it.           */

   Off = iV[1] + iV[0] * (NsmP * sCol + TmRow);
   vP = (void *)(cP[1] + Off);

/* OK now transfer the data to a ByTe_4 array.  We need to create the   */
/*   array and fill it according to the stored data size                */

   Bytes = nE * sizeof(ReaL_8);
   if ((memPtr = malloc (Bytes)) == NULL) { return TCL_ERROR; }
   rPt = (ReaL_8 *)memPtr;
   if ( iV[0] == 4 ) {
       lPt = (ByTe_4 *)vP;
       for (I =0; I < nE; ++I) { *rPt++ = *lPt++; }
   } else if ( iV[0] == 2 ) {
       sPt = (ByTe_2 *)vP;
       for (I =0; I < nE; ++I) { *rPt++ = *sPt++; }
   } else {
       cPt = (ByTe_1 *)vP;
       for (I =0; I < nE; ++I) { *rPt++ = *cPt++; }
   } 

/* DO any necessary format conversions                                   */

   rPt = (ReaL_8 *)memPtr;
   if (iV[3] == 0) {
      ToUnsign_C ( memPtr, (int)nE, (int)iV[2]);
   } else if (iV[3] > 1) {
      ToFloat_C ( memPtr, (int)nE, (int)iV[3]);
   }

/* FILL the TCL array with the data                                      */

   sprintf (VarN, "ExData%s", N);
   Tcl_UpVar(tI, "#0", VarN, "eP", 0);

   rPt = (ReaL_8 *)memPtr;
   for (I = 0; I < nE; ++I, ++rPt) {
      sprintf(Index, "%d", I);
      rV1 = Tcl_DuplicateObj(rV1);
      Tcl_SetDoubleObj (rV1, *rPt);
      Tcl_SetVar2Ex(tI, "eP", Index, rV1, Flg);
   }

/* SET ExDa NSMP                                                         */

   Tcl_UpVar(tI, "#0", "ExDa", "eXDa", 0);
   sprintf (VarN, "%s,NSMP", N);
   rV1 = Tcl_DuplicateObj(rV1);
   Tcl_SetIntObj (rV1, nE);
   Tcl_SetVar2Ex(tI, "eXDa", VarN, rV1, Flg);

/* GET rid of the temporary array and return                             */
   
   free (memPtr);
   return TCL_OK;
}
