/*  This routine will pick of various blocks of stored data.           */
/*                                                                     */
/*  Case 0:  Pointers to binary UDF Header and Data records            */
/*  Case 1:  Timing Data         ,TM,                                  */
/*  Case 2:  General Data (VIDF) ,GN,                                  */
/*  Case 3:  Sensor Set Data     ,SS,                                  */
/*  Case 4:  UDF Data            ,N,                                   */
/*  Case 5:  General data for DataSen.c                                */
/*  Case 6:  Algorithm line definitions                                */

#include <tcl.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "ByteDefs.h"
#include "TudfAnsi.h"

ByTe_4 BlockVar (Tcl_Interp *tI, ByTe_4 Block, ByTe_1 *iD1, ByTe_1 *iD2, 
                          u_ByTe_1 **rP, ByTe_1 *rV, ByTe_4 bG, Tcl_Obj *tOp)
{
    ByTe_4 *lP;
    ByTe_4 T;

    int Len, eC, V, I;
    int Flg = TCL_LEAVE_ERR_MSG;

    ByTe_1 Index[50], *S;

    Tcl_Obj *rVO;

    switch (Block) {
       case 0:
         sprintf(Index, "%s,HEADER", iD1);
         rVO = Tcl_GetVar2Ex(tI, "SInfo", Index, Flg); 
         rP[0] = Tcl_GetByteArrayFromObj(rVO, &Len); 

         sprintf(Index, "%s,DATA", iD1);
         rVO = Tcl_GetVar2Ex(tI, "SInfo", Index, Flg); 
         rP[1] = Tcl_GetByteArrayFromObj(rVO, &Len); 

       break;
       case 1:
         lP = (ByTe_4 *)rV + bG; 
         CGetVar (tI, "SInfo", iD1, ",TM,TOTMS", 'L', (ByTe_1 *)lP++);
         CGetVar (tI, "SInfo", iD1, ",TM,TOTNS", 'L', (ByTe_1 *)lP++);
         CGetVar (tI, "SInfo", iD1, ",TM,SMPMS", 'L', (ByTe_1 *)lP++);
         CGetVar (tI, "SInfo", iD1, ",TM,SMPNS", 'L', (ByTe_1 *)lP++);
         CGetVar (tI, "SInfo", iD1, ",TM,ROWMS", 'L', (ByTe_1 *)lP++);
         CGetVar (tI, "SInfo", iD1, ",TM,ROWNS", 'L', (ByTe_1 *)lP++);
         CGetVar (tI, "SInfo", iD1, ",TM,COLMS", 'L', (ByTe_1 *)lP++);
         CGetVar (tI, "SInfo", iD1, ",TM,COLNS", 'L', (ByTe_1 *)lP++);
       break;
       case 2:
         lP = (ByTe_4 *)rV + bG; 
         CGetVar (tI, "SInfo", iD1, ",GN,SMPID",    'L', (ByTe_1 *)lP++);
         CGetVar (tI, "SInfo", iD1, ",GN,SENMODE",  'L', (ByTe_1 *)lP++);
         CGetVar (tI, "SInfo", iD1, ",GN,DAMETHOD", 'L', (ByTe_1 *)lP++);
         CGetVar (tI, "SInfo", iD1, ",GN,SCANLEN",  'L', (ByTe_1 *)lP++);
       break;
       case 3:
         lP = (ByTe_4 *)rV + bG; 
         CGetVar (tI, "SInfo", iD1, ",SS,TMROW", 'L', (ByTe_1 *)lP++);
         CGetVar (tI, "SInfo", iD1, ",SS,TMCOL", 'L', (ByTe_1 *)lP++);
       break;
       case 4:
         lP = (ByTe_4 *)rV + bG; 
         CGetVar (tI, "ExDa", iD1, ",SEN",  'L', (ByTe_1 *)lP++);
         CGetVar (tI, "ExDa", iD1, ",SPIN", 'L', (ByTe_1 *)lP++);
         CGetVar (tI, "ExDa", iD1, ",ZERO", 'L', (ByTe_1 *)lP++);
         CGetVar (tI, "ExDa", iD1, ",COL",  'L', (ByTe_1 *)lP++);
       break;
       case 5:
         lP = (ByTe_4 *)rV + bG; 
         CGetVar (tI, "ExDa", iD2, ",SEN",  'L', (ByTe_1 *)&T);
         CGetVar (tI, "SInfo", iD1, ",GN,SBLEN", 'L', (ByTe_1 *)lP++);
         CGetVar (tI, "SInfo", iD1, ",PT,TOSS", 'L', (ByTe_1 *)lP++);
         CGetListVar (tI, "SInfo", iD1, ",GN,SLEN", T, -1, 'L', (ByTe_1 *)lP++);
         CGetListVar (tI, "SInfo", iD1, ",GN,DTYPE", T, -1, 'L', (ByTe_1 *)lP++);
       break;
       case 6:
         lP = (ByTe_4 *)rV + bG; 
         for (I = 0; I < 7; ++I) {  
            eC = Tcl_ListObjIndex (tI, tOp, I, &rVO);
            if (I != 4 ) {
               Tcl_GetIntFromObj(tI, rVO, &V);
               *lP++ = V;
            } else {
               S = Tcl_GetStringFromObj(rVO, &Len);
               *lP++ = S[0];
            }
         }
       break;
    }

   return 1;
}
