package provide ShockNormal 1.0

#  INPUTS:  
#     Normal - the shock normal vector

proc SNshockVel { Base } {
   global SNcommon guiAns N1 V1 N2 V2 sP

   set nV(0) $guiAns(X$Base)
   set nV(1) $guiAns(Y$Base)
   set nV(2) $guiAns(Z$Base)

   set J 0
   for { set I 0 } { $I < $SNcommon(Pt1) } { incr I ; incr J 3} {
      set X($I) $N1($I)
      set Y($I) [expr $N1($I) * [TUvecMath V1 DOT nV nV $J]]
   }
   set AvG  [TUarrayMath Y AVG Y Y $SNcommon(Pt1)]
   set VarY [TUarrayMath Y VAR AvG Y $SNcommon(Pt1)]
   for { set I 0 } { $I < $SNcommon(Pt1) } { incr I } { set yVaR($I) $VarY }

   set P $SNcommon(Pt1)
   set J 0
   for { set I 0 } { $I < $SNcommon(Pt2) } { incr I ; incr P ; incr J 3} {
      set X($P) $N2($I)
      set Y($P) [expr $N2($I) * [TUvecMath V2 DOT nV nV $J]]
   }

   set P $SNcommon(Pt1)
   set AvG  [TUarrayMath Y AVG Y Y $SNcommon(Pt2) $SNcommon(Pt1)]
   set VarY [TUarrayMath Y VAR AvG Y $SNcommon(Pt2) $SNcommon(Pt1)]
   for { set I 0 } { $I < $SNcommon(Pt2) } { incr I ; incr P } {
      set yVaR($P) $VarY
   }

   set nP [expr $SNcommon(Pt1) + $SNcommon(Pt2)]
   set iA(0) 1 ; set iA(1) 1
   set ChiSq [TUdataLSq1D X Y $nP 1 A iA 2 CoVar TUpolyFunc yVaR ]
   set SNcommon(sV$Base)  [expr $A(1) / $sP(1)]
   set SNcommon(sVi$Base) [expr $A(0)/ $sP(0) / $sP(1)]

   set guiAns(SV$Base)  [format "%.3e" $A(1)]
   set guiAns(SVs$Base) [format "%.3e" [expr sqrt($CoVar(3))]]

#  SNsvelPlot X Y $nP $Base

   update
}
