package provide ShockNormal 1.0

# Base - Solution method
#  0:  Magnetic Colplanarity
#  1:  Abraham-Shrauner
#  2:  Velocity Colplanarity

proc SNshockSol { Base } {
   global PI RtoD N1 V1 B1 N2 V2 B2 SNcommon guiAns  

   set fPI [expr 4.0 * $PI]

# Set the number of data points to include on each side depending on if
#    the data is being PERMUTATED or MIRRORED
 
   set I 0
   set L 0
   set M 0
   set N 0
   if [string match MIRRORED $guiAns(duse)] {
      set ToProcess 1
      upvar 0 I Km
      upvar 0 M Vm
   } else {
      set ToProcess $SNcommon(Pt2)
      upvar 0 L Km
      upvar 0 N Vm
   }
   set nP1 $SNcommon(Pt1)
   set nP  [expr $ToProcess * $nP1]

# SOLVE for the shock normal and velocity according to the method requested

   set Q1 0
   switch -exact -- $Base {
      0 {  for {set I 0}  { $I < $nP1 } { incr I ; incr M 3 } {
              set N 0
              set L 0
              TUvecMath V1 * N1 Part1 $M $I 0 3 1 
              for {set J 0}  {$J < $ToProcess} {incr J ; incr L } {
                 set dN(0) [expr $N2($Km) - $N1($I)]
                 TUvecMath B1 - B2 dB $M $Vm 
                 TUvecMath B1 CROSS B2 BcB $M $Vm
                 TUvecMath BcB CROSS dB Bn 
                 set Mag [TUvecMath Bn UNIT Bn Sum 0 0 $Q1]
                 incr N 3
                 incr Q1 3
              }
           }
        }
      1 {  for {set I 0}  { $I < $SNcommon(Pt1) } { incr I ; incr M 3 } {
              set N 0
              set L 0
              TUvecMath V1 * N1 Part1 $M $I 0 3 1 
              for {set J 0}  {$J < $ToProcess} {incr J ; incr L } {
                 set dN(0) [expr $N2($Km) - $N1($I)]
                 TUvecMath B2 - B1 dB $Vm $M
                 TUvecMath V2 - V1 dV $Vm $M
                 TUvecMath dB CROSS dV BcV
                 TUvecMath dB CROSS BcV Bn 
                 set Mag [TUvecMath Bn UNIT Bn Sum 0 0 $Q1]
                 incr N 3
                 incr Q1 3
              }
           }
        }
      2 {  for {set I 0}  { $I < $SNcommon(Pt1) } { incr I ; incr M 3 } {
              set N 0
              set L 0
              TUvecMath V1 * N1 Part1 $M $I 0 3 1 
              for {set J 0}  {$J < $ToProcess} {incr J ; incr L } {
                 set dN(0) [expr $N2($Km) - $N1($I)]
                 TUvecMath V2 - V1 dV $Vm $M
                 set Mag [TUvecMath dV UNIT dV Sum 0 0 $Q1]
                 incr N 3
                 incr Q1 3
              }
           }
        }
   }

   set tP [expr 3 * $SNcommon(Pt)]
   set nV(0)  [TUarrayMath Sum AVG Sum Sum $tP 0 0 0 3 ]
   set sD [expr sqrt([TUarrayMath Sum VAR nV(0) Sum $tP 0 0 0 3])]
   set guiAns(X$Base)  [format "%.3e" $nV(0)]
   set guiAns(Xs$Base)  [format "%.3e" $sD]

   set nV(1)  [TUarrayMath Sum AVG Sum Sum $tP 1 0 0 3 ]
   set sD [expr sqrt([TUarrayMath Sum VAR nV(1) Sum $tP 1 0 0 3])]
   set guiAns(Y$Base)  [format "%.3e" $nV(1)]
   set guiAns(Ys$Base)  [format "%.3e" $sD]

   set nV(2)  [TUarrayMath Sum AVG Sum Sum $tP 2 0 0 3 ]
   set sD [expr sqrt([TUarrayMath Sum VAR nV(2) Sum $tP 2 0 0 3])]
   set guiAns(Z$Base)  [format "%.3e" $nV(2)]
   set guiAns(Zs$Base)  [format "%.3e" $sD]

   SNshockVel $Base

   update

# NOW compute the alfven mach number and theta B,N.  This is done only
#  on the upstream low entroy side of the shock

   if { $SNcommon(Side) == 0 } {
      SNdataAnc $Base $SNcommon(Pt1) N1 V1 B1
   } else { SNdataAnc $Base $SNcommon(Pt2) N2 V2 B2 }
}
