package provide ShockNormal 1.0

#  This procedure computes the velocities used in computing the last
#  two Rankine-Hugoniot (Pressure and Heat Flux) equations. 

proc SNrhVels { I Nv Nt CV1 CV2 { eQs 5 } } {
   global bV nV1 nB1 nV2 nB2 guiAns SNcommon 

   upvar $Nv  nV
   upvar $Nt  nT
   upvar $CV1 cV1
   upvar $CV2 cV2

   set X [expr 3 * $I]

   if { $eQs == 5 } {
      set K  0
      set L  5
      TUvecMath nV1 - bV tV $X $X 0 
      for { set J 0 } { $J < 15 } { incr J 3 ; incr K ; incr L } {
         set cV1($K) [TUvecMath  tV DOT nV nV  0 $J]
         set cV1($L) [TUvecMath nB1 DOT nV nV $X $J]
      }
      TUvecMath cV1 * cV1 cV1 0 0 10 5 5

      set K  0
      set L  5
      TUvecMath nV2 - bV tV $X $X 0 
      for { set J 0 } { $J < 15 } { incr J 3 ; incr K ; incr L } {
         set cV2($K) [TUvecMath  tV DOT nV nV  0 $J]
         set cV2($L) [TUvecMath nB2 DOT nV nV $X $J]
      }
      TUvecMath cV2 * cV2 cV2 0 0 10 5 5

      set K 15
      set L 20
      set M 25
      for { set I 0 } { $I < 45 } { incr I 9 ; incr K ; incr L; incr M  } {
         TUmatrixMath nT * nV1 tVa 3 3 3 1 $I $X 
         TUmatrixMath nT * nB1 tVb 3 3 3 1 $I $X 
         set cV1($K) [TUvecMath tVa DOT tVa tVa ]
         set cV1($L) [TUvecMath tVb DOT tVb tVb ]
         set cV1($M) [TUvecMath tVa DOT tVb tVb ]
      }
      TUvecMath cV1 * cV1 cV1 15 10 30 5 5

      set K 15
      set L 20
      set M 25
      for { set I 0 } { $I < 45 } { incr I 9 ; incr K ; incr L; incr M  } {
         TUmatrixMath nT * nV2 tVa 3 3 3 1 $I $X 
         TUmatrixMath nT * nB2 tVb 3 3 3 1 $I $X 
         set cV2($K) [TUvecMath tVa DOT tVa tVa ]
         set cV2($L) [TUvecMath tVb DOT tVb tVb ]
         set cV2($M) [TUvecMath tVa DOT tVb tVb ]
      }
      TUvecMath cV2 * cV2 cV2 15 10 30 5 5
   } else {
      TUvecMath nV1 - bV tV $X $X 
      set cV1(0) [TUvecMath  tV DOT nV nV ]
      set cV1(1) [TUvecMath nB1 DOT nV nV $X ]
      set cV1(2) [expr $cV1(0) * $cV1(0)]

      TUvecMath nV2 - bV tV $X $X 0 
      set cV2(0) [TUvecMath  tV DOT nV nV ]
      set cV2(1) [TUvecMath nB2 DOT nV nV $X ]
      set cV2(2) [expr $cV2(0) * $cV2(0)]

      TUmatrixMath nT * nV1 tVa 3 3 3 1 0 $X 
      TUmatrixMath nT * nB1 tVb 3 3 3 1 0 $X 
      set cV1(3) [TUvecMath tVa DOT tVa tVa ]
      set cV1(4) [TUvecMath tVb DOT tVb tVb ]
      set cV1(5) [TUvecMath tVa DOT tVb tVb ]
      set cV1(6) [expr $cV1(2) * $cV1(3)]

      TUmatrixMath nT * nV2 tVa 3 3 3 1 0 $X 
      TUmatrixMath nT * nB2 tVb 3 3 3 1 0 $X 
      set cV2(3) [TUvecMath tVa DOT tVa tVa ]
      set cV2(4) [TUvecMath tVb DOT tVb tVb ]
      set cV2(5) [TUvecMath tVa DOT tVb tVb ]
      set cV2(6) [expr $cV2(2) * $cV2(3)]
   }
}
