package provide ShockNormal 1.0

# Solutions to the Rankine-Hugonoit equations and the derivitives with
# respect tp phi and theta.  The derivitives are computed analytically.

proc SNrhFunc { nA dAdY Ops } {
   global FuNc dFuNc aV bV dB dP cV aT SNcommon nN1 nN2 nP1 nP2 guiAns

   upvar $Ops oP
   upvar $dAdY dA

# SET twice the angular delta.  The Phi and Theta deltas are identical

   set TdA [expr 2.0 * $SNcommon(dA)]

# SET the number of equations being solved

   if { $SNcommon(PoK) > 1 } { set nEQ 9 } else { set nEQ 7 } 

# IF looking for the first RH value then solve for all of them and
# their derivitives. After that parcel them out as they are requested.
#
# THE RH values are stored in the array FuNc and the derivitives are
# stored in the array dFuNc

   if { $oP(4) == 0 } {
      set A(0) $oP(5)
      set A(1) $oP(6)
      set rH 0
      set drH 0
      SNcoefExpand A nV

# SET UP the following tensors.  These depend only on the shock normal 
# angles and therefore needs to only be computed once per iteration.  The 
# tensor is computed 5 times, once for the cell center and once for each
# of the 4 edges of the cell.  
#
#  nT:   1.0 - nVx * nVx      - nVx * nVy       - nVx * nVz 
#            - nVy * nVx  1.0 - nVy * nVy       - nVy * nVz 
#            - nVz * nVx      - nVz * nVy   1.0 - nVz * nVz
#
#  vT:         nVx * nVx        nVx * nVy         nVx * nVz 
#              nVy * nVx        nVy * nVy         nVy * nVz 
#              nVz * nVx        nVz * nVy         nVz * nVz
#

      set uT(0) 1.0 ; set uT(1) 0.0 ; set uT(2) 0.0
      set uT(3) 0.0 ; set uT(4) 1.0 ; set uT(5) 0.0
      set uT(6) 0.0 ; set uT(7) 0.0 ; set uT(8) 1.0

      for { set I 0 ; set J 0 } { $I < 15 } { incr I 3 ; incr J 9 } {
         TUvecMath nV TENSOR nV vT $I $I $J
         TUvecMath uT   -    vT nT  0 $J $J 9 9
      }

# SOLUTIONS to Rankine-Hugonoit Equations and the derivitives with respect
# to PHI and THETA.  These are computed per data vector. 

      set T 0 
      set X 0 
      for { set S 0 } { $S < $SNcommon(Pt) } { incr S ; incr X 3 ; incr T 9 } {
         set N 0

# COMPUTE the shock velocities for the center and cell edges.

         for { set I 0; set J 0 } { $I < 15 } { incr I 3 ; incr J } {
            set Vsh($J) [TUvecMath bV DOT nV nV $X $I]
         }

# SOLUTION to Rankine-Hugonoit Equations. 
# EQUATION 1: B DOT N

         for { set I 0 ; set J 0 } { $I < 15 } { incr I 3 ; incr J 9 } {
            set eQ($J) [TUvecMath dB DOT nV nV $X $I]
         }

# SET up the vectors and tensors used in computations of RH equations 2-4
#
#  xV:   aVx * Vshk   aVy * Vshk   aVz * Vshk
#
#  xT:   aTxx * nVx    aTxy * nVy    aTxz * nVz 
#        aTyx * nVx    aTyy * nVy    aTyz * nVz 
#        aTzx * nVx    aTzy * nVy    aTzz * nVz
#  
#  yT:   nVx * nVx * aVx   nVx * nVy * aVy   nVx * nVz * aVz 
#        nVy * nVx * aVx   nVy * nVy * aVy   nVy * nVz * aVz 
#        nVz * nVx * aVx   nVz * nVy * aVy   nVz * nVz * aVz
#
         set K 0
         for { set I 0 ; set J 0 } { $I < 15 } { incr I 3 ; incr J } {
            TUvecMath aV * Vsh xV  $X $J $I  3 1
            TUvecMath nT * xV  xT  $K $I $K  9 3
            TUvecMath aT * nV  yT  $T $I $K  9 3
            TUmatrixMath nT * yT zT 3 3 3 3 $K $K $K
            incr K 9
         }

# EQUATIONS 2-4:  Tangential Stress Vector

         set M 0
         for { set J 0 } { $J < 5 } { incr J } {
            set N [expr $J * 9 + 1]
            for { set K 0 } { $K < 3 } { incr K ; incr N ; incr M 3 } {
               set eQ($N) [TUarrayMath zT SUM zT zT 3 $M ]
               set eQ($N) [expr $eQ($N) - [TUarrayMath xT SUM xT xT 3 $M]]
            }
         }

# Set up the vectors and tensors
#
# xV:  (cVy * qEz - cVz * qEy) (cVz * qEx - cVx * qEz) (cVx * qEy - cVy * qEz)
#
# yV:  (dBx * Vshk)  (dBy * Vshk)  (dBz * Vshk)   
#
# xT:  nTxx * yVx   nTxy * yVy   nTxz * yVz 
#      nTyx * yVx   nTyy * yVy   nTyz * yVz 
#      nTzx * yVx   nTzy * yVy   nTzz * yVz

         set K 0
         for { set I 0 ; set J 0 } { $I < 15 } { incr I 3 ; incr J } {
            TUvecMath cV CROSS nV xV $X $I $I
            TUvecMath dB * Vsh yV $X $J $I 3 1
            TUvecMath nT * yV  xT $K $I $K 9 3 
            incr K 9
         }

# EQUATIONS 5-7 : Tangential Electric Field Vector

         set M 0
         for { set J 0 ; set I 0 } { $J < 5 } { incr J } {
            set N [expr $J * 9 + 4]
            for { set K 0 } { $K < 3 } {incr K ; incr N ; incr I ; incr M 3 } {
               set eQ($N) [expr $xV($I) - [TUarrayMath xT SUM xT xT 3 $M ]]
            }
         }

# EQUATIONS 8 and 9 are only valid if both the electron and ion temperature
#    data has been included in the input file.

         if { $nEQ == 9 } {
            SNrhVels $S nV nT cV1 cV2
            set TmP(0) 0.5

# EQUATION 8 : Pressure

            TUvecMath cV1 * nN1 tV1 10 $S  0 5 1
            TUvecMath cV2 * nN2 tV2 10 $S  0 5 1
            TUvecMath tV2 - tV1 tVa  0  0  0 5 5
            TUvecMath cV2 - cV1 tVb 20 20  0 5 5
            TUvecMath tVb * TmP tVb  0  0  0 5 1
            TUvecMath tVa + tVb   G  0  0  0 5 5
            TUvecMath   G +  dP   G  0  0  0 5 1
            for { set I 7 ; set J 0 } { $I < 45 } { incr I 9 ; incr J } { 
               set eQ($I) $G($J) 
            }

# EQUATION 9 : Heat Flux

            set TmP(1) [expr $guiAns(gamma) / ($guiAns(gamma) - 1.0)]
            TUvecMath cV1 * nP1 tV1  0 $S  0 5 1
            TUvecMath cV2 * nP2 tV2  0 $S  0 5 1
            TUvecMath tV2 - tV1   G  0  0  0 5 5
            TUvecMath   G * TmP   G  0  1  0 5 1

            TUvecMath cV1 * nN1 tV1  0 $S  0 5 1
            TUvecMath tV1 * cV1 tV1  0 30  0 5 5
            TUvecMath cV2 * nN2 tV2  0 $S  0 5 1
            TUvecMath tV2 * cV2 tV2  0 30  0 5 5
            TUvecMath tV2 - tV1 tVa  0  0  0 5 5
            TUvecMath tVa * TmP tVa  0  0  0 5 1
            TUvecMath   G + tVa   G  0  0  0 5 5

            TUvecMath cV1 * cV1 tV1  0 20  0 5 5
            TUvecMath cV2 * cV2 tV2  0 20  0 5 5
            TUvecMath tV2 - tV1 tVa  0  0  0 5 5
            TUvecMath   G + tVa   G  0  0  0 5 5

            TUvecMath cV1 * cV1 tV1  5 25  0 5 5
            TUvecMath cV2 * cV2 tV2  5 25  0 5 5
            TUvecMath tV2 - tV1 tVa  0  0  0 5 5
            TUvecMath   G - tVa   G  0  0  0 5 5

            for { set I 8 ; set J 0 } { $I < 45 } { incr I 9 ; incr J } { 
               set eQ($I) $G($J) 
            }
         }

         set FuNc($rH) [TUvecMath eQ MAG eQ eQ 0 0 0 $nEQ]
         set dpP [TUvecMath eQ MAG eQ eQ 9 9 0 $nEQ]
         set dmP [TUvecMath eQ MAG eQ eQ 18 18 0 $nEQ]
         set dpT [TUvecMath eQ MAG eQ eQ 27 27 0 $nEQ]
         set dmT [TUvecMath eQ MAG eQ eQ 36 36 0 $nEQ]
         set dFuNc($drH) [expr ($dpP - $dmP) / $TdA] ; incr drH
         set dFuNc($drH) [expr ($dpT - $dmT) / $TdA]
         incr rH ; incr drH
      }
   }
   set dA(0) $dFuNc([expr 2 * $oP(4)])
   set dA(1) $dFuNc([expr 2 * $oP(4) + 1])
   return $FuNc($oP(4))
}
