package provide ShockNormal 1.0

proc SNrhFit { Y WgT CoeF Hold } {
    global RtoD PI PltInfo GphInfo guiAns nV SNcommon

    upvar $Y    yV
    upvar $CoeF A
    upvar $Hold iA
    upvar $WgT  W

# MAKE the initial call to the NonLinear Least Squares fit to do all of the
#   one-time initializations

    set oP(0) -1.0
    TUdataNLinLSq yV W $SNcommon(Pt) A iA 2 SNrhFunc oP

# INITIALIZE the MaxCnt.  This counts the number of iterations made and
#   gets us out of the loop at some predefined number of iterations whether
#   the minimum change in ChiSq has been reached or not.

    set MaxCnt  0

# NOW start iterating and continue until either a MaxCnt is reached or until
#    the search step size [op(0)] becomes overly large

    while { ($MaxCnt < $SNcommon(MaxIter)) && ($oP(0) < 10000.0) } {

# UPDATE the current solution in the gui info page.

       SNnvUpdate A nV -1 -1 oP

# SAVE the previous ChiSq value and rerun the non-linear least squares fit
    
       TUdataNLinLSq yV W $SNcommon(Pt) A iA 2 SNrhFunc oP

# INCREMENT the maximun iteration counter

       incr MaxCnt
    }

# ONE last call to the least squares routine to get the covariance and the
#    curvature matrices

    set oP(0) 0.0
    TUdataNLinLSq yV W $SNcommon(Pt) A iA 2 SNrhFunc oP

# UPDATE the current solution in the gui info page, show its location on
#   the surface plot and then compute the statistics.

    SNnvUpdate A nV White 1 oP
    return $oP(1)
}
