package provide ShockNormal 1.0

# Solutions to the Rankine-Hugonoit equations and the derivitives with
# respect tp phi and theta.  The derivitives are computed analytically.
# as derivitives are deltas off the RH equations.

proc SNrhEq { Phi Theta } {
   global RtoD aV bV dB dP cV aT SNcommon nN1 nN2 nP1 nP2 guiAns

# SET the number of equations being solved
 
   if { $SNcommon(PoK) > 1 } { set nEQ 9 } else { set nEQ 7 }

#  Get the estimated shock normals for the input angles

   set A(0) [expr $Phi / $RtoD] 
   set A(1) [expr $Theta / $RtoD]
   set rH 0.0
   SNcoefExpand A nV

# SET UP the following tensor.  This depends only on the shock normal 
# angles and therefore needs to only be computed once per angle set.
#
#  nT:   1.0 - nVx * nVx      - nVx * nVy       - nVx * nVz
#            - nVy * nVx  1.0 - nVy * nVy       - nVy * nVz
#            - nVz * nVx      - nVz * nVy   1.0 - nVz * nVz
#
   set uT(0) 1.0 ; set uT(1) 0.0 ; set uT(2) 0.0
   set uT(3) 0.0 ; set uT(4) 1.0 ; set uT(5) 0.0
   set uT(6) 0.0 ; set uT(7) 0.0 ; set uT(8) 1.0
   TUvecMath nV TENSOR nV nT
   TUvecMath uT   -    nT nT 0 0 0 9 9

# SOLUTIONS to Rankine-Hugonoit Equations and the derivitives with respect
# to PHI and THETA.  These are computed per data vector. 

   set X 0
   set T 0
   for { set S 0 } { $X < $SNcommon(Pt) } { incr S ; incr X 3 ; incr T 9 } {

# COMPUTE the shock velocities for the center and cell edges.

      set Vsh(0) [TUvecMath bV DOT nV nV $X]

# SOLUTION to Rankine-Hugonoit Equations. 
# EQUATION 1

      set F(0) [TUvecMath dB DOT nV nV $X]

# SET up the vectors and tensors used in computations of RH equations 2-4
#
#  xV:   aVx * Vshk   aVy * Vshk   aVz * Vshk
#
#  xT:   aTxx * nVx    aTxy * nVy    aTxz * nVz 
#        aTyx * nVx    aTyy * nVy    aTyz * nVz 
#        aTzx * nVx    aTzy * nVy    aTzz * nVz
#  
#  yT:   nVx * nVx * AVx   nVx * nVy * AVy   nVx * nVz * AVz 
#        nVy * nVx * AVx   nVy * nVy * AVy   nVy * nVz * AVz 
#        nVz * nVx * AVx   nVz * nVy * AVy   nVz * nVz * AVz
#
#  zT:   nVx * eTxx * aTxx   nVx * eTxy * aTxy   nVx * eTxz * aTxz 
#        nVx * eTyx * aTyx   nVx * eTyy * aTyy   nVx * eTyz * aTyz 
#        nVx * eTzx * aTzx   nVx * eTzy * aTzy   nVx * eTzz * aTzz 
#        nVy * eTxx * aTxx   nVy * eTxy * aTxy   nVy * eTxz * aTxz 
#        nVy * eTyx * aTyx   nVy * eTyy * aTyy   nVy * eTyz * aTyz 
#        nVy * eTzx * aTzx   nVy * eTzy * aTzy   nVy * eTzz * aTzz 
#        nVz * eTxx * aTxx   nVz * eTxy * aTxy   nVz * eTxz * aTxz 
#        nVz * eTyx * aTyx   nVz * eTyy * aTyy   nVz * eTyz * aTyz 
#        nVz * eTzx * aTzx   nVz * eTzy * aTzy   nVz * eTzz * aTzz 

      TUvecMath aV * Vsh xV  $X  0  0  3 1
      TUvecMath nT * xV  xT   0  0  0  9 3
      TUvecMath aT * nV  yT  $T  0  0  9 3
      TUmatrixMath nT * yT zT 3 3 3 3

# EQUATIONS 1-3

      set M 0
      set N 1
      for { set J 0 } { $J < 3 } { incr J ; incr M 3 } {
         set F($N) [TUarrayMath zT SUM zT zT 3 $M ]
         set F($N) [expr $F($N) - [TUarrayMath xT SUM xT xT 3 $M]]
         incr N
      }

# Set up the vectors and tensors
#
# xV:  (cVy * qEz - cVz * qEy) (cVz * qEx - cVx * qEz) (cVx * qEy - cVy * qEz)
#
# yV:  (dBx * Vshk)  (dBy * Vshk)  (dBz * Vshk)   
#
# xT:  nVx * nVx * dvBx   nVx * nVy * dvBy   nVx * nVz * dvBz 
#      nVy * nVx * dvBx   nVy * nVy * dvBy   nVy * nVz * dvBz 
#      nVz * nVx * dvBx   nVz * nVy * dvBy   nVz * nVz * dvBz

      TUvecMath cV CROSS nV xV $X
      TUvecMath dB * Vsh yV $X  0  0 3 1
      TUvecMath nT * yV  xT  0  0  0 9 3

# EQUATIONS 4-6

      set N 4
      set M 0
      for { set I 0 } { $I < 3 } { incr I ; incr M 3 ; incr N } {
         set F($N) [expr $xV($I) - [TUarrayMath xT SUM xT xT 3 $M ]]
      }

# EQUATIONS 7 and 8 are only valid if both the electron and ion temperature
#    data has been included in the input file.

      if { $nEQ == 9 } {
         SNrhVels $S nV nT cV1 cV2 1

# EQUATION 8 : Pressure

         set F(7) [expr $dP($S) + $nN2($S) * $cV2(2) - $nN1($S) * $cV1(2)]
         set F(7) [expr $F(7) + 0.5 * ($cV2(4) - $cV1(4))]

# EQUATION 9 : Heat Flux

         set gm [expr $guiAns(gamma) / ($guiAns(gamma) - 1.0)]
         set F(8) [expr $gm * ($nP2($S) * $cV2(0) - $nP1($S) * $cV1(0))]
         set TmP2 [expr $nN2($S) * $cV2(0) * $cV2(6)]
         set TmP1 [expr $nN1($S) * $cV1(0) * $cV1(6)]
         set F(8) [expr $F(8) + 0.5 * ($TmP2 - $TmP1)]
         set F(8) [expr $F(8) + $cV2(0) * $cV2(4) - $cV1(0) * $cV1(4)]
         set F(8) [expr $F(8) - $cV2(1) * $cV2(5) + $cV1(1) * $cV1(5)]
      }

# TIE UP ALL EQUATIONS to give solutions and derivitives

      set rH [expr $rH + [TUvecMath F MAG F F 0 0 0 $nEQ]]
   }

   return [expr $rH / double ($SNcommon(Pt) - 1.0)]
}
