package provide ShockNormal 1.0

# THIS PROGRAM READS IN THE SHOCK DATA

proc SNreadData { } {
   global SNcommon guiAns TimE DeN MagF VeL TemPi TemPe pDN pMF pVE pTM
   
# THESE are the file ID and variable iD lists

   set fiD [list A B C D E]
   set viD [list B Ti Te N V Tipp Tepp ]

# GET a list of the files which need to be processed. Check for all 
#    possibilites since there may be a gap in the list.

   set fNames ""
   for { set I 0 } { $I < 5 } { incr I } { 
      set iD [lindex $fiD $I]
      if { [string length $guiAns(fN$iD)] > 0 } {
         lappend fNames [list $guiAns(fN$iD) $iD]
      }
   }
   set nF [llength $fNames]

# LOOP over tall the files to be process

   set tN 0
   for { set I 0 } { $I < $nF } { incr I } { 
      set fInfo [lindex $fNames $I]
      set nFile [lindex $fInfo 0]
      set iD [lindex $fInfo 1]

# OPEN the data file returning a warning if this can't be done

      if [catch { open $nFile r } fd ] {
         set eMsg "ERROR ... CANNOT OPEN FILE\n $nFile"
         GUImsgPopUp .ewin 30 5 $eMsg
         return
      }

# DETERMINE the format to use to parse the file, where the first variable is
#   in a data line, the number of data variables being returned and what data
#   variables are being returned. The vInfo variable returns the units

      set rFmT [SNfileFormat $iD nV vO vList vInfo]

# OK - we got the data file opened and the format to use to read it so now
#   its time to read it.  
#
# N is the array counter
# tS is the starting position in the time array for these data values

      set N 0
      set tS $tN
      while { [gets $fd LinE] >= 0 } {
         set LinE [string trim $LinE]
         if { [string index $LinE 0] == "#" } { continue }
	 set V [scan $LinE $rFmT]

# FORM the Year and Day of Year of the Time field

	 set TimE($tN) [SNformTime $iD $V]

# PICK up the data

         for { set J $vO ; set K 0 } { $K < $nV } { incr K } { 
            switch -exact -- [lindex $vList $K] {
	       B {
	          set Bx($N) [lindex $V $J] ; incr J
	          set By($N) [lindex $V $J] ; incr J
	          set Bz($N) [lindex $V $J] ; incr J
	       }
	       V {
	          set Vx($N) [lindex $V $J] ; incr J
	          set Vy($N) [lindex $V $J] ; incr J
	          set Vz($N) [lindex $V $J] ; incr J
	       }
	       Tipp { 
	          set T1 [lindex $V $J] ; incr J 
	          set T2 [lindex $V $J] ; incr J 
		  set Ti($N) [expr sqrt($T1 * $T1 + $T2 * $T2)]
               }
	       Tepp { 
	          set T1 [lindex $V $J] ; incr J 
	          set T2 [lindex $V $J] ; incr J 
	          set Te($N) [expr sqrt($T1 * $T1 + $T2 * $T2)]
               }
	       Ti { set Ti($N) [lindex $V $J] ; incr J }
	       Te { set Te($N) [lindex $V $J] ; incr J }
	       N  { set Dn($N) [lindex $V $J] ; incr J }
	    }
	 }

         incr N 
         incr tN 
      }

# CLOSE the data file 

      close $fd

# SET up the start and stop time poisitions in the time array for each of
#   the variables obtaind in the file

      for { set J 0 } { $J < $nV } { incr J } { 
         switch -exact -- [lindex $vList $J] {
	    V  { lappend vInfo(V) $tS ; lappend vInfo(V) [expr $tN -1] }
	    B  { lappend vInfo(B) $tS ; lappend vInfo(B) [expr $tN -1] }
	    Tipp  -
	    Ti  { lappend vInfo(Ti) $tS ; lappend vInfo(Ti) [expr $tN -1] }
	    Tepp  -
	    Te  { lappend vInfo(Te) $tS ; lappend vInfo(Te) [expr $tN -1] }
	    N   { lappend vInfo(N) $tS ; lappend vInfo(N) [expr $tN -1] }
	 }
      }
   }

# Convert all of the data to the right units

   SNdataUnits Dn Ti Te Vx Vy Vz Bx By Bz vInfo

# GET all the data sets onto a common grid

   SNcommonGrid Dn Ti Te Vx Vy Vz Bx By Bz vInfo

# SEE if we got temperature data.  If we did we can include pressure in
#   the computation.

   set nP $SNcommon(nP)
   if { [info exists vInfo(Ti)] || [info exists vInfo(Te)] } {
      set SNcommon(PoK) 1
      if { [info exists vInfo(Ti)] && [info exists vInfo(Te)] } {
         for { set J 0 } { $J < $nP } { incr J } {
	    set Tp($J) [expr $Te($J) + $Ti($J)]
	 }
      } elseif [info exists vInfo(Ti)] {
         for { set J 0 } { $J < $nP } { incr J } { set Tp($J) $Ti($J) }
      } else {
         for { set J 0 } { $J < $nP } { incr J } { set Tp($J) $Te($J) }
      }
   } else { 
      set SNcommon(PoK) 0 
      for { set J 0 } { $J < $nP } { incr J } { set Tp($J) 0.0 }
   }

# RUN the data through any data filters.  Even if the data is not to be
#   filtered this will put the data into their final data arrays.  Both
#   V and B are stored in Vector arrays

   SNdataFilter Dn Tp Vx Vy Vz Bx By Bz

# LAST set up the plot arrays

   for { set I 0; set X 0 } {$I < $nP } { incr I ; incr X 3 } { 
      set pDN($I) $DeN($I)
      set pTM($I) $Tp($I)
      set pMF($I) [TUvecMath MagF MAG MagF MagF $X]
      set pVE($I) [TUvecMath VeL MAG VeL VeL $X]
   }
}
