package provide ShockNormal 1.0

#INPUTS  
#   
#  Grid     The grid being filled
#  gInfo    The grid information array used to build array    
#  pInfo    Information used to set up plot
#     Element  0:  Label to use for X axis    
#     Element  1:  Label to use for Y axis    
#     Element  2:  Label to use for the ColorBar axis    
#     Element  3:  Scaling to apply to the X axis
#     Element  4:  Scaling to apply to the Y axis
#     Element  5:  Scaling to apply to the ColorBar axis
#     Element  6:  Minimum ColorBar scaling
#     Element  7:  Maximum ColorBar scaling


proc SNplotPT { Grid gInfo Phi Theta } {
   global PltInfo WinInfo GphInfo

   upvar $Grid G
   upvar $gInfo gI
   upvar $Phi P
   upvar $Theta T

   set pI(0) THETA
   set pI(1) PHI
   set pI(3) 0
   set pI(4) 0
   set nP [expr int($gI(4) * $gI(5))]

   SetScreen 1 .gmCHISQ.plot
   ClearWindow bW1 $GphInfo(Black)
   update

# HERE we try to get reasonable placement of the colorbar and reasonable
#   character sizes for labels based on the window size

# THE length of the area allocated for the colorbar is dY.  The following
#  determines the charactersize which will closest put 5 characters vertically
#  across that area.  The colorbar itself is then spread over the space of
#  two characters leaving 1.5 characters above and below for labeling.

   set GphInfo(curWin) bW1
   set dY [expr 0.15 * ($WinInfo(bW1,pp4) - $WinInfo(bW1,pp1))]
   set cbSize 12
   TextProp $cbSize
   set Yc [GPHtextLen "55555" Y ]
   while { ($Yc > $dY) && ($cbSize > 6) } {
      incr cbSize -1
      TextProp $cbSize
      set Yc [GPHtextLen "55555" XY ]
   }
   set dY [expr (0.90/0.75 - 1.0) / 5.0]
   set Yb [expr 1.0 + 1.5 * $dY]
   set Ye [expr 1.0 + 3.5 * $dY]

# NOW get the best labeling size for the surface plot.  TotX is the blank
#   area to the left of the surface plot and ToTY the blank area below it.
#   Need 5.5 characters to the left an 3.5 below.

#  set GphInfo(curWin) 3
   set TotX [expr 0.2 * ($WinInfo(bW1,pp3) - $WinInfo(bW1,pp0))]
   set TotY [expr 0.1 * ($WinInfo(bW1,pp4) - $WinInfo(bW1,pp1))]
   set cSize 12
   TextProp $cSize
   set cL [GPHtextLen "5" XY ]
   set Xc [expr 5.5 * [lindex $cL 0]]
   set Yc [expr 3.5 * [lindex $cL 1]]
   while { (($Yc > $TotY) || ($Xc > $TotX)) && ($cSize > 5) } {
      incr cSize -1
      TextProp $cSize
      set cL [GPHtextLen "5" XY ]
      set Xc [expr 5.5 * [lindex $cL 0]]
      set Yc [expr 3.5 * [lindex $cL 1]]
   }

# DON'T want the colorbar labeling bigger than the plot labeling
   
   if { $cSize < $cbSize } { set cbSize $cSize } 

   GenWindow 10 0.2 0.1 0.0 0.95 0.85 0.0 $gI(0) $gI(2) 0. $gI(1) $gI(3) 0. 

   set ReT [TUdataMxMn G $nP <> 0.0 1000.0]
   set pI(6) $G([lindex $ReT 0])
   set pI(7) $G([lindex $ReT 1])
   if { $pI(6) <= 0.0 } { 
      set ReT [PLTautoScale $pI(6) $pI(7) 0 4]
      set FmT "%.[lindex $ReT 2]f"
      set pI(6) [lindex $ReT 0]
      set pI(7) [lindex $ReT 1]
      if { $pI(6) < 0 } {
         set pI(7) [expr $pI(7) - $pI(6)]
         set pI(6) 0.0
      }
      set pI(5) 0
   } else {
      set Ratio [expr $pI(7) / $pI(6)]
      if { $Ratio < 100.0 } {
         set ReT [PLTautoScale $pI(6) $pI(7) 0 4]
         set FmT "%.[lindex $ReT 2]f"
         set pI(6) [lindex $ReT 0]
         set pI(7) [lindex $ReT 1]
         if { $pI(6) < 0 } {
            set pI(7) [expr $pI(7) - $pI(6)]
            set pI(6) 0.0
         }
         set pI(5) 0
      } else {
         set pI(5) 1
         set FmT expon
      }
   }

   if {$pI(5) == 0 } {
      set pI(2) "STANDARD DEVIATION"
   } else { set pI(2) "LOG(STANDARD DEVIATION)" }

   set cInputs(pMIN)      $pI(6)
   set cInputs(pMAX)      $pI(7)
   if { $pI(5) == 1 } {set cInputs(pSCA) LOG} else {set cInputs(pSCA) LINEAR}
   set cInputs(WHITE)     NO
   set cInputs(FMT)       LHORIZONTAL
   set cInputs(POS)       ABSOLUTE
   set cInputs(ANNOTATE)  YES
   set cInputs(AXIS)      YES
   set cInputs(PRIMARY)   TICMJ:TICMN:NUM:LABEL
   set cInputs(SECONDARY) TICMJ:TICMN:NUM:LABEL
   set cInputs(PSIZE)     HOLD:HOLD:$cbSize:$cbSize
   set cInputs(SSIZE)     HOLD:HOLD:$cbSize:$cbSize
   set cInputs(PFMTS)     HOLD:HOLD:$FmT
   set cInputs(PNUMS)     2:10
   set cInputs(LABELS)    ":$pI(2)"
   set cInputs(LEV)       0.75:0.75
                                                                                
   set cW [ColorBar 10 0.1 $Yb 0.0 0.9 $Ye 0.0 cInputs cIa cIb]

   DefinePlot 10 10
   PLTinfoChg 10 ALL NUMBERS NSIZE $cSize 
   PLTinfoChg 10 ALL NUMBERS TSIZE $cSize 
   PLTinfoChg 10 ALL NUMBERS NFORMAT %.0f 
   PLTinfoChg 10 xb TICKS MJNUMBER 4 
   PLTinfoChg 10 xb TICKS MNNUMBER 6 
   
   Plot3D 10 Xb Yb Dummy Dummy G AUTO gI cIa
   PlotOutlines 10 [list "$pI(0)" 1.0 $pI(1) 1.0] 

   set wN $PltInfo(10,wN)
   TextProp 8
   TexT $wN $T(0) $P(0) 0.0 center "MC" $GphInfo(Black)
   TexT $wN $T(1) $P(1) 0.0 center "AS" $GphInfo(Black)
   TexT $wN $T(2) $P(2) 0.0 center "VC" $GphInfo(Black)
}
