package provide ShockNormal 1.0

#INPUTS  
#   
#  Grid     The grid being filled
#  gInfo    The grid information array used to build array    
#  pInfo    Information used to set up plot
#     Element  0:  Label to use for X axis    
#     Element  1:  Label to use for Y axis    
#     Element  2:  Label to use for the ColorBar axis    
#     Element  3:  Scaling to apply to the X axis
#     Element  4:  Scaling to apply to the Y axis
#     Element  5:  Scaling to apply to the ColorBar axis
#     Element  6:  Minimum ColorBar scaling
#     Element  7:  Maximum ColorBar scaling


proc SNmeterPT { Percent Action Color } {
   global PltInfo WinInfo GphInfo

   SetScreen 1 .gmCHISQ.plot
   if { $Action == 0 } {
      ClearWindow bW1 $GphInfo(Black)

# HERE we set up the percentage meter

      PlotColor HOLD $GphInfo(White) HOLD
      GenWindow 20 0.45 0.2 0.0 0.55 0.8 0.0 0.0 0.0 0.0 1.0 100.0 0.0
      WinClip 20 1

      DefinePlot 20 20
      PLTinfoChg 20 ALL NUMBERS NSIZE 10
      PLTinfoChg 20 ALL NUMBERS TSIZE 10
      PLTinfoChg 20 ALL TICKS MJNUMBER 4
      PLTinfoChg 20 ALL TICKS MNNUMBER 5
      PLTinfoChg 20 ALL TICKS MJLENGTH .3
      PLTinfoChg 20 ALL TICKS MNLENGTH .2
      PlotOutlines 20 [list "" 1 "% DONE" 1  "" 1 "" 1] \
                      [list NONE TOP NONE BOTH]
  } else {
     set Percent [expr $Percent * 100.0]
     PlotColor HOLD $Color $Color
     Box 20 0.0 0.0 0.0 1.0 $Percent 0.0
     PlotColor HOLD HOLD -1
  }
  update
}
