package provide ShockNormal 1.0

proc SNmasvCal { Data Vsh } {
   global PI RtoD N1 V1 B1 N2 V2 B2 SNcommon 
 
   upvar $Data E
   set fPI [expr 4.0 * $PI]

   if { $SNcommon(Side) == 0 } {
      upvar 0 N1 D
      upvar 0 V1 V
      upvar 0 B1 B
      set nP $SNcommon(Pt1)
   } else {
      upvar 0 N2 D
      upvar 0 V2 V
      upvar 0 B2 B
      set nP $SNcommon(Pt2)
   }

   set K 0
   for { set I 0 } { $I < $nP } { incr I ; incr K 3} {
      set Mag [TUvecMath B UNIT B TmP $K]
      set BdN [TUvecMath E DOT TmP E ] 
      if { [expr abs($BdN)] > 1.0 } {
         if { $BdN < 0.0 } { set BdN -1.0 } else { set BdN 1.0 }
      }
      set TBn($I) [expr $RtoD * acos($BdN)] 
      set VTn [TUvecMath V DOT E V $K ]
      set vA [expr 1.0e-5 * $Mag / sqrt($fPI * $SNcommon(Mass) * $D($I))]
      set aM($I) [expr 1.0e5 * abs($VTn - $Vsh) / $vA] 
   }

   set ReT [TUdataStat TBn $nP]
   set rEt [TUdataStat aM $nP]
   return [list [lindex $ReT 0] [lindex $rEt 0 ]]
}
