package provide ShockNormal 1.0

proc SNguiStart { } {
  global Prefs SNcommon guiDefaults guiAns env

# DO some beginning initializations 

   SNguiInit

# READ in the preference file

   GUIprefsRead

# READ the color table options

   set ctFile [file join $env(TCLTOOLS_HOME) TclGPH ColorTables GPH.Ctables]
   if [catch {open $ctFile r} fd] {
      set Msg "ERROR: Can't open Color Table Info file $ctFile"
      GUImsgPopUp .ewin 30 5 $Msg
      return -1
   }

   set FOps ""
   while { [gets $fd line] > 0 } { lappend FOps "CTBL: $line" }
   set CTLab [lindex [split [lindex $FOps 0] '|'] 0 ] 
   set guiAns(ctbl) [lindex [split [lindex $FOps 0] '|'] 1 ] 
   close $fd

# DO some scaling for the plotting canvases

   set tSize [font measure "$Prefs(Font) $Prefs(FontSize)" ABCD]
   set sSize [font measure "$Prefs(Font) $Prefs(FontSize)" A]
   set MinSize [expr $tSize * 10]
   if {$guiDefaults(cX) < $MinSize } { set guiDefaults(cX) $MinSize }
   if {$guiDefaults(cXs) < $MinSize } { set guiDefaults(cXs) $MinSize }

# LAY out the window names for the GUI frame structure 

   set Wm  .gmMIDDLE
   set Wc  .gmCHISQ
   set Wmt .gmMIDDLE.top
   set Wma .gmMIDDLE.topA
   set Wmd .gmMIDDLE.data
   set Wct .gmCHISQ.top
   set Wcp .gmCHISQ.plot

   if { [winfo exists .gmMIDDLE] == 0 } {
      wm title . "SHOCK NORMAL PROGRAM"

      GUIFrame $Wm -1 pack|left||both
      GUIFrame $Wc -1 pack|left||both

      GUIFrame $Wmt -1 pack|top||x
      GUIFrame $Wma -1 pack|top||x
      GUIFrame $Wmd -1 pack|top||x

      GUIFrame $Wct -1 pack|top||x
      GUIFrame $Wcp -1 pack|top||x

      GUIbuttonPush $Wmt.quit Quit pack|right "exit" 6
      GUIbuttonMenu $Wmt.ctbl $CTLab pack|right $FOps  \
           "GUIoptsProcess .gmMIDDLE.top.ctbl guiAns(ctbl) ALT " 6
      GUIbuttonPush $Wmt.pref Preferences pack|right "GUIprefsSet" 6
      GUIbuttonPush $Wmt.info "Info Page" pack|left "SNguiInfoCtrl" 6
      GUIbuttonPush $Wma.file "New\nFile" grid|0|0|news "SNnewData" 6
      GUIbuttonPush $Wma.plot "Data\nPlot"  grid|0|1|news \
           "SNplotData .gmMIDDLE.data" 6
      GUIbuttonPush $Wma.setup "Surface\nPlot" grid|0|2|news "SNrhSetUp" 6
      GUIbuttonPush $Wma.solve  "Solve\nRH" grid|0|3|news "SNrhSolve" 6
      GUIbuttonPush $Wma.asym  "RH\nAsymtotes" grid|0|4|news "SNasymSolve" 6

      GUIstateSet $Wma.plot  PBUTTON disabled
      GUIstateSet $Wma.setup PBUTTON disabled
      GUIstateSet $Wma.solve PBUTTON disabled
      GUIstateSet $Wma.asym  PBUTTON disabled

      bind $Wmt.pref <Button-3> {SNmsgHelp Pref}
      bind $Wma.setup <Button-3> {SNmsgHelp SetUp}

      GUILabel $Wct.tlab1 "RANKINE-HUGONIOT" c grid|0|0|ew||2
      GUILabel $Wct.tlab2 "DIFFERENCE SURFACE PLOT" c grid|1|0|ew||2
      GUIblankRow $Wct 2 1.0
      GUILabel $Wct.tlab3 "SOLUTION RESOLUTION" c grid|3|0|ew
      GUILabel $Wct.tlab4 "GRID RESOLUTION" c grid|4|0|ew

      set FOps [list 30x30 15x15 10x10 5x5 4x4 3x3 2x2 1x1]
      GUIbuttonMenu $Wct.sres $guiAns(sres) grid|3|1|e $FOps "SNchgSurface sres"

      set FOps [list 30x30 15x15 10x10 5x5 4x4 3x3 2x2 1x1]
      GUIbuttonMenu $Wct.gres $guiAns(gres) grid|4|1|e $FOps "SNchgSurface gres"

      GUICanvas $Wmd $guiDefaults(cX) $guiDefaults(cY) \
                     $guiDefaults(cXs) $guiDefaults(cYs)

      set vX [expr int($guiDefaults(cX) * 0.5)]
      set vY [expr $guiDefaults(cY) - 2.5 * $sSize]
      if [string match NO $guiDefaults(PTs)] {
         set sX $vX
         set sY $vY
      } else {
         set sX [expr int($guiDefaults(cXs) * 0.5)]
         set sY [expr $guiDefaults(cY) - 2.5 * $sSize]
      }
      GUICanvas $Wcp  $vX $vY $sX $sY

# PUT up the logo

      set sList [list 720 640 560 480 400]
      set I 0
      set Home [file join $env(TCLTOOLS_HOME) TclSN]
      while { ([lindex $sList $I] > $guiDefaults(cX)) && ($I < 5) } { incr I }
      if { $I < 4 } {
         set ImG [file join $Home Logo[lindex $sList $I].ppm]
         image create photo loGo -format ppm -file $ImG
         $Wmd.drw create image [expr $guiDefaults(cX)/2] \
                   [expr $guiDefaults(cY)/2] -image loGo -anchor c -tags LoGo
      } else {
         set hList [list 360 320 280 240 200]
         set I 0
         while {([lindex $hList $I] > $guiDefaults(cX)) && ($I < 5)} { incr I }
         if { $I < 4 } {
            set ImG [file join $Home Logo[lindex $sList $I].ppm]
            image create photo loGo -format ppm -file $ImG
            sloGo copy loGo -subsample 2 2 -shrink
            $Wmd.drw create image [expr $guiDefaults(cX)/2] \
                   [expr $guiDefaults(cY)/2] -image sloGo -anchor c -tags LoGo
         }
      } 

      SNguiInfo
      update
   }

# Read in saved options if passed in.

   if $guiAns(NeedRead) { set guiAns(NeedRead) 0 ; SNreadMenu }

# SET the mouse bindings
 
   bind .gmMIDDLE.data.drw <Button-1> {SNgetTime %W %x %y}
   bind .gmMIDDLE.data.drw <Button-3> {SNlineDel %W %x %y}
   bind .gmCHISQ.plot.drw <Button-1> {SNgetNormal %W %x %y}
   bind .gmCHISQ.plot.drw <Button-3> {SNnormalDel %W %x %y}
}
