package provide ShockNormal 1.0

proc SNguiInfo { } {
  global Prefs SNcommon guiDefaults guiAns

# LAY out the window names for the GUI frame structure 

   SNguiData
   set W  .giINFO

   if { [winfo exists $W] == 0 } {
      toplevel $W
      wm title . "SHOCK NORMAL INFO PAGE"

      set Wa .giINFO.top
      set Wal .giINFO.top.l
      set War .giINFO.top.r
      set Wd .giINFO.data
      set Wb .giINFO.time
      set Wc .giINFO.results

      GUIFrame $Wa -1 pack|top||both
      GUIFrame $Wd -1 pack|top||both
      GUIFrame $Wb -1 pack|top||both
      GUIFrame $Wc -1 pack|top||both
      GUIFrame $Wal -1 pack|left||both
      GUIFrame $War -1 pack|right||both

      GUIbuttonPush $War.close CLOSE pack|right|ne "SNguiInfoCtrl" 6 
      GUIbuttonPush $Wal.lread READ grid|0|0|w "SNreadMenu" 6
      GUIboxEntry $Wal.read grid|0|1|w 40 guiAns(ReadName)
      GUIbuttonPush $Wal.lsave SAVE grid|1|0|w "SNsaveMenu" 6
      GUIboxEntry $Wal.save grid|1|1|w 40 guiAns(SaveName)
      GUIbuttonPush $Wal.lprnt PRINT grid|2|0|w SNprintRes 6
      GUIboxEntry $Wal.prnt grid|2|1|w 40 guiAns(PrintName)

      set Row 0

      GUILabel $Wd.lduse  "Usage"       c grid|$Row|1|ew
      GUILabel $Wd.lfilt  "Data Filter" c grid|$Row|2|ew
      GUILabel $Wd.lflen  "Length"      c grid|$Row|3|ew
      GUILabel $Wd.lsgor  "SG Order"    c grid|$Row|4|ew

      incr Row
      set FOps [list MIRRORED PERMUTATED]
      GUIbuttonToggle $Wd.duse $guiAns(duse) grid|$Row|1 $FOps "SNdataChg 0"
      set FOps [list  NONE SAVITZKYGOLAY MOVINGWINDOW]
      GUIbuttonMenu $Wd.dsmo $guiAns(dSmooth) grid|$Row|2 $FOps "SNdataChg 1" 
      GUIboxEntry $Wd.flen grid|$Row|3 7 guiAns(dFlen)
      GUIboxEntry $Wd.sgo  grid|$Row|4 7 guiAns(dSGorder)
      incr Row
      GUIblankRow $Wd $Row 1.0
      incr Row
      GUILabel $Wd.lgamma "Gamma" c grid|$Row|0|e
      GUIboxEntry $Wd.gamma grid|$Row|1|news 7 guiAns(gamma)
      incr Row
      GUIblankRow $Wd $Row 1.0
      incr Row

      set SdList [list "Side-1 Time A" "Side-1 Time B" "Shock Time" \
                       "Side-2 Time A" "Side-2 Time B" ]
      set TmList [list s1Ta s1Tb skTm s2Ta s2Tb]

      GUILabel $Wb.lyy "Year"   c grid|$Row|1|ew
      GUILabel $Wb.ldy "Day"    c grid|$Row|2|ew
      GUILabel $Wb.lhr "Hour"   c grid|$Row|3|ew
      GUILabel $Wb.lmn "Minute" c grid|$Row|4|ew
      GUILabel $Wb.lsc "Second" c grid|$Row|5|ew
      GUILabel $Wb.lms "MSec"   c grid|$Row|6|ew

      set Len [ llength $TmList ]
      for { set I 0 } { $I < $Len } { incr I } {
          incr Row
          set Nm [lindex $TmList $I]
          GUILabel $Wb.l$Nm [lindex $SdList $I] c grid|$Row|0|e
          GUIboxEntry $Wb.${Nm}yy grid|$Row|1 7 guiAns(${Nm}Yr)
          GUIboxEntry $Wb.${Nm}dy grid|$Row|2 7 guiAns(${Nm}Dy)
          GUIboxEntry $Wb.${Nm}hr grid|$Row|3 7 guiAns(${Nm}Hr)
          GUIboxEntry $Wb.${Nm}mn grid|$Row|4 7 guiAns(${Nm}Mn)
          GUIboxEntry $Wb.${Nm}sc grid|$Row|5 7 guiAns(${Nm}Sc)
          GUIboxEntry $Wb.${Nm}ms grid|$Row|6 7 guiAns(${Nm}Ms)
      }

      set Row 0
      GUILabel $Wc.lshk SHOCK: c grid|$Row|1|ew 1
      GUIvLabel $Wc.shki guiAns(shki) c grid|$Row|2|w||5 1 0 #fe0000
      incr Row
      GUIblankRow $Wc $Row 1.0
      incr Row
      GUILabel $Wc.lmc "Magnetic Coplanarity" c grid|$Row|1|ew||2 1 0 #00fe00
      GUILabel $Wc.las "Abraham-Shrauner" c grid|$Row|3|ew||2 1 0 #00fe00
      GUILabel $Wc.lvc "Velocity Coplanarity" c grid|$Row|5|ew||2 1 0 #00fe00
      GUILabel $Wc.lvs "Vinas-Scudder" c grid|$Row|7|ew||2 1 0 #00fe00

      set RSdList [list Nx Ny Nz Phi Theta Vs TBn Ma N1 Vx1 Vy1 Vz1 \
                        Bx1 By1 Bz1 N2 Vx2 Vy2 Vz2 Bx2 By2 Bz2 dP]
      set ResList [list X Y Z PH TH SV TBN MA NA VXA VYA VZA BXA BYA BZA \
                                              NB VXB VYB VZB BXB BYB BZB DP ]
      set Len [ llength $ResList ]

      for { set I 0 } { $I < $Len } { incr I } {
          incr Row
          set Nm [lindex $ResList $I]
          GUILabel $Wc.l$Nm [lindex $RSdList $I] c grid|$Row|0|e 5 0 #00fe00
          GUIvLabel $Wc.mc$Nm guiAns(${Nm}0) c grid|$Row|1|e 0 9 
          GUIvLabel $Wc.mcs$Nm guiAns(${Nm}s0) c grid|$Row|2|e 0 9 #0000fe
          GUIvLabel $Wc.as$Nm guiAns(${Nm}1)  c grid|$Row|3|e 0 9
          GUIvLabel $Wc.ass$Nm guiAns(${Nm}s1) c grid|$Row|4|e 0 9 #0000fe
          GUIvLabel $Wc.vc$Nm guiAns(${Nm}2)  c grid|$Row|5|e 0 9
          GUIvLabel $Wc.vcs$Nm guiAns(${Nm}s2) c grid|$Row|6|e 0 9 #0000fe
          GUIvLabel $Wc.vs$Nm guiAns(${Nm}3)  c grid|$Row|7|e 0 9
          GUIvLabel $Wc.vss$Nm guiAns(${Nm}s3) c grid|$Row|8|e 0 9 #0000fe
      }

      bind $Wd.flen <Return> { SNdataChg 2}
      bind $Wd.sgo  <Return> { SNdataChg 3}

      wm withdraw $W 
      update
   }
}
