package provide ShockNormal 1.0

proc SNguiDefaults { } {

  global guiDefaults env

  set guiDefaults(sres)  10x10
  set guiDefaults(gres)  5x5
  set guiDefaults(duse) MIRRORED
  set guiDefaults(smooth) NONE
  set guiDefaults(cX) 520
  set guiDefaults(cY) 640
  set guiDefaults(cXs) 520
  set guiDefaults(cYs) 640
  set guiDefaults(MaxIter) 500
  set guiDefaults(PTs) NO
  set guiDefaults(gamma) 1.5
  set guiDefaults(flen)    2
  set guiDefaults(sgorder) 2

  set OK 1
  if [catch {open SNDefaults r} fd] {
     set Home [file join $env(TCLTOOLS_HOME) TclSN SNDefaults]
     if [catch {open $Home r} fd] { set OK 0 }
  }

  if $OK {
     while { [gets $fd line] > 0 } {
         set Title [lindex [split $line ':'] 0]
         set Value [lindex [split $line ':'] 1]
         set Value [string trim $Value]
         switch -glob -- $Title {
            Solution*      { set guiDefaults(sres)    $Value }
            Grid*          { set guiDefaults(gres)    $Value }
            Process*       { set guiDefaults(duse)    $Value }
            VPlotWidth*    { set guiDefaults(cX)      $Value }
            VPlotHeight*   { set guiDefaults(cY)      $Value }
            TPlotWidth*    { set guiDefaults(cXs)     $Value }
            TPlotHeight*   { set guiDefaults(cYs)     $Value }
            MaxIterations* { set guiDefaults(MaxIter) $Value }
            PTScroll*      { set guiDefaults(PTs)     $Value }
            Gamma*         { set guiDefaults(gamma)   $Value }
            Smooth*        { set guiDefaults(smooth)  $Value }
            FilterLen*     { set guiDefaults(flen)    $Value }
            SGOrder*       { set guiDefaults(sgorder) $Value }
         }
     }
     close $fd
  } 
}
