package provide ShockNormal 1.0
 
proc SNguiAsym { aVal Base Side }  {
   global SNcommon sP guiAns N1 V1 B1 P1 N2 V2 B2 P2

   upvar $aVal mRH

   set Den [expr $mRH(0) * $sP(0)]
   set Vx  [expr $mRH(1) * $sP(1)]
   set Vy  [expr $mRH(2) * $sP(1)]
   set Vz  [expr $mRH(3) * $sP(1)]
   set Bx  [expr $mRH(4) * $sP(2)]
   set By  [expr $mRH(5) * $sP(2)]
   set Bz  [expr $mRH(6) * $sP(2)]

   if { $Side == 1 } {
      set guiAns(NA$Base)  [format "%.3e" $Den]
      set guiAns(VXA$Base) [format "%.3e" $Vx]
      set guiAns(VYA$Base) [format "%.3e" $Vy]
      set guiAns(VZA$Base) [format "%.3e" $Vz]
      set guiAns(BXA$Base) [format "%.3e" $Bx]
      set guiAns(BYA$Base) [format "%.3e" $By]
      set guiAns(BZA$Base) [format "%.3e" $Bz]

      set nP $SNcommon(Pt1)
      set VnP [expr 3 * $SNcommon(Pt1)]
      set sD [expr sqrt([TUarrayMath N1 VAR Den N1 $nP])]
      set guiAns(NAs$Base)  [format "%.3e" $sD]
      set sD [expr sqrt([TUarrayMath V1 VAR Vx V1 $VnP 0 0 0 3])]
      set guiAns(VXAs$Base)  [format "%.3e" $sD]
      set sD [expr sqrt([TUarrayMath V1 VAR Vy V1 $VnP 1 0 0 3])]
      set guiAns(VYAs$Base)  [format "%.3e" $sD]
      set sD [expr sqrt([TUarrayMath V1 VAR Vz V1 $VnP 2 0 0 3])]
      set guiAns(VZAs$Base)  [format "%.3e" $sD]
      set sD [expr sqrt([TUarrayMath B1 VAR Bx B1 $VnP 0 0 0 3])]
      set guiAns(BXAs$Base)  [format "%.3e" $sD]
      set sD [expr sqrt([TUarrayMath B1 VAR By B1 $VnP 1 0 0 3])]
      set guiAns(BYAs$Base)  [format "%.3e" $sD]
      set sD [expr sqrt([TUarrayMath B1 VAR Bz B1 $VnP 2 0 0 3])]
      set guiAns(BZAs$Base)  [format "%.3e" $sD]
   } else {
      set guiAns(NB$Base)  [format "%.3e" $Den]
      set guiAns(VXB$Base) [format "%.3e" $Vx]
      set guiAns(VYB$Base) [format "%.3e" $Vy]
      set guiAns(VZB$Base) [format "%.3e" $Vz]
      set guiAns(BXB$Base) [format "%.3e" $Bx]
      set guiAns(BYB$Base) [format "%.3e" $By]
      set guiAns(BZB$Base) [format "%.3e" $Bz]

      set nP $SNcommon(Pt2)
      set VnP [expr 3 * $SNcommon(Pt2)]
      set sD [expr sqrt([TUarrayMath N2 VAR Den N2 $nP])]
      set guiAns(NBs$Base)  [format "%.3e" $sD]
      set sD [expr sqrt([TUarrayMath V2 VAR Vx V2 $VnP 0 0 0 3])]
      set guiAns(VXBs$Base)  [format "%.3e" $sD]
      set sD [expr sqrt([TUarrayMath V2 VAR Vy V2 $VnP 1 0 0 3])]
      set guiAns(VYBs$Base)  [format "%.3e" $sD]
      set sD [expr sqrt([TUarrayMath V2 VAR Vz V2 $VnP 2 0 0 3])]
      set guiAns(VZBs$Base)  [format "%.3e" $sD]
      set sD [expr sqrt([TUarrayMath B2 VAR Bx B2 $VnP 0 0 0 3])]
      set guiAns(BXBs$Base)  [format "%.3e" $sD]
      set sD [expr sqrt([TUarrayMath B2 VAR By B2 $VnP 1 0 0 3])]
      set guiAns(BYBs$Base)  [format "%.3e" $sD]
      set sD [expr sqrt([TUarrayMath B2 VAR Bz B2 $VnP 2 0 0 3])]
      set guiAns(BZBs$Base)  [format "%.3e" $sD]
   } 

   update
}
