package provide ShockNormal 1.0

# THIS procedure gets the data into the correct units if not already there.

proc SNdataUnits { Dn T1 T2 V1 V2 V3 B1 B2 B3 vInfo } {
   global SNcommon TimE 

   upvar $vInfo vI

   set vL [list Dn T1 T2 V1 V2 V3 B1 B2 B3 ]
   set vN [list N Ti Te V V V B B B ]
   
   set nV [llength $vL]
   for { set I 0 } { $I < $nV } { incr I } {
      set ConV 1.0
      set vA "$[lindex $vL $I]"
      eval upvar $vA DaTa
      if [info exists DaTa] { 
         set viD "[lindex $vN $I]"
	 set Units [lindex $vI($viD) 0]
	 set nP [expr [lindex $vI($viD) 2] - [lindex $vI($viD) 1] + 1]
         switch -exact -- $viD {
	    B {
               switch -exact -- $Units {
	          g  {  set ConV 1.0e-4    }
	          nT {  set ConV 1.0       }
	       }
	    }
	    V {
               switch -exact -- $Units {
	          cm/s { set ConV 1.0e-5   } 
	          m/s  { set ConV 1.0e-3   } 
	          km/s { set ConV 1.0      } 
	       }
            }
	    N {
               switch -exact -- $Units {
	          /cm**3 { set ConV 1.0    } 
	          /m**3  { set ConV 1.0e-6 } 
	       }
            }
	    Ti -
	    Te {
               switch -exact -- $Units {
	          K   { set ConV 1.0        } 
	          mK  { set ConV 1.0e3      }  
	          eV  { set ConV 11604.5    }
	          keV { set ConV 11604500.0 }
	       }
            }
	 }

	 if { $ConV != 1.0 } {
            for { set J 0 } { $J < $nP } { incr J } { 
                set DaTa($J) [expr $DaTa($J) * $ConV]
            }
         }
      }
   }
}
