package provide ShockNormal 1.0

#  INPUTS
#     Time         (fractions of day)
#     N            Number of data points
#  OUTPUTS
#     None
#
#  GLOBALS


proc SNdataReMap { Time nP } {
   global SNcommon PltInfo

   upvar $Time Tm
  
   set LineiD   [list S S1a S1b S2a S2b] 

# IF all the times haven't been set give warning and return negative value

   if { $SNcommon(nLines) != 2 } { 
      set Msg "ERROR: To many or two few times selected\n\
               for data to be zoomed."
      GUImsgPopUp .ewin 30 5 $Msg
      return -1
   }
 
# ORDER the selsected times

   set I 0
   set J 0
   while { ($I < 5) && ($J < 2) } {
      set iD Pix[lindex $LineiD $I]
      if { $SNcommon($iD) > 0 } { 
         set T($J) $SNcommon($iD)
         set RmId($J) Line[lindex $LineiD $I]
         incr J
      }
      incr I
   }

   if { $T(0) > $T(1) } {
      set TmP $T(0)
      set T(0) $T(1)
      set T(1) $TmP
   }

# COMPUTE the decimal time of the start and stop zoom times

   set Info $PltInfo(0,TmI)
   set T(0) [expr [lindex $Info 2] + $T(0) * [lindex $Info 6]]
   set T(1) [expr [lindex $Info 2] + $T(1) * [lindex $Info 6]]

#  GET the index of the new beginning data point 

   set N 0
   while { ($Tm($N) < $T(0)) && ($N < $nP) } { incr N }

#  GET the index of the new ending data point 

   set M $N
   while { ($Tm($M) < $T(1)) && ($M < $nP) } { incr M }

   set SNcommon(dEnd) [expr $M + $SNcommon(dBeg) - 1]
   set SNcommon(dBeg) [expr $N + $SNcommon(dBeg)]

   SNlineDel 0 0 0 $RmId(0)
   SNlineDel 0 0 0 $RmId(1)
}
