package provide ShockNormal 1.0

proc SNdataFilter { Dn Tm V1 V2 V3 B1 B2 B3 } {
   global guiAns SNcommon MagF VeL TemP DeN

   upvar $Dn D 
   upvar $Tm T 
   upvar $V1 Vx 
   upvar $V2 Vy 
   upvar $V3 Vz 
   upvar $B1 Bx 
   upvar $B2 By 
   upvar $B3 Bz 
   
   set Op(0) $guiAns(dFlen)
   set Op(1) $guiAns(dFlen)
   set Op(2) $guiAns(dSGorder)

   if [string match SAVITZKYGOLAY $guiAns(dSmooth)] {
      set nP 1
      while { $nP < $SNcommon(nP) } { set nP [expr $nP * 2] }
      if { $nP > $SNcommon(nP) } {
         set tP $nP
      } else { set tP $SNcommon(nP) }
   } else { set tP $SNcommon(nP) }

   for { set I $SNcommon(nP) } { $I < $tP } { incr I } {
      set Bx($I) 0.0
      set By($I) 0.0
      set Bz($I) 0.0
      set Vx($I) 0.0
      set Vy($I) 0.0
      set Vz($I) 0.0
      set D($I) 0.0
      set T($I) 0.0
   }

   TUdataFilter Bx $tP $guiAns(dSmooth) Op fXm
   TUdataFilter By $tP $guiAns(dSmooth) Op fYm
   TUdataFilter Bz $tP $guiAns(dSmooth) Op fZm
   TUdataFilter Vx $tP $guiAns(dSmooth) Op fXv
   TUdataFilter Vy $tP $guiAns(dSmooth) Op fYv
   TUdataFilter Vz $tP $guiAns(dSmooth) Op fZv
   TUdataFilter T  $tP $guiAns(dSmooth) Op TemP
   TUdataFilter D  $tP $guiAns(dSmooth) Op DeN

   for { set I 0 ; set X 0 } { $I < $SNcommon(nP) } { incr I } {
      set MagF($X) $fXm($I)
      set VeL($X)  $fXv($I) ; incr X
      set MagF($X) $fYm($I)
      set VeL($X)  $fYv($I) ; incr X
      set MagF($X) $fZm($I)
      set VeL($X)  $fZv($I) ; incr X
   }
}
