package provide ShockNormal 1.0

#  Given the a shock normal vector (NV) together with the unput plasma
#    data the routine computes the normal phi and theta angles as well
#    as Theta B,N and tha Alfven Mach Number.  These are posted to the
#    GUI info page.

proc SNdataAnc { Base nP Den Vel Mf } {
   global PI RtoD SNcommon guiAns  

   upvar $Den D
   upvar $Vel V
   upvar $Mf  B

   set fPI [expr 4.0 * $PI]

   set nV(0) $guiAns(X$Base)
   set nV(1) $guiAns(Y$Base)
   set nV(2) $guiAns(Z$Base)
   set vS    $guiAns(SV$Base)

   set guiAns(TH$Base) [format "%.3e" [expr $RtoD * acos($nV(0))]]
   set guiAns(PH$Base) [format "%.3e" \
                           [expr $RtoD * ($PI - atan2($nV(2), -$nV(1)))]]

   set K 0
   for { set I 0 } { $I < $nP } { incr I ; incr K 3 } {
      set Mag [TUvecMath B UNIT B TmP $K]
      set BdN [TUvecMath nV DOT TmP nV ] 
      if { [expr abs($BdN)] > 1.0 } {
         if { $BdN < 0.0 } { set BdN -1.0 } else { set BdN 1.0 }
      }
      set TBn($I) [expr $RtoD * acos($BdN)] 
      set VTn [TUvecMath V DOT nV V $K ]
      set vA [expr 1.0e-5 * $Mag / sqrt($fPI * $SNcommon(Mass) * $D($I))]
      set aM($I) [expr 1.0e5 * abs($VTn - $vS) / $vA] 
   }

    set tBN  [TUarrayMath TBn AVG TBn TBn $nP ]
    set stBN [expr sqrt([TUarrayMath TBn VAR tBN TBn $nP])]
    set guiAns(TBN$Base)  [format "%.3e" $tBN]
    set guiAns(TBNs$Base)  [format "%.3e" $stBN]
    set AM   [TUarrayMath aM AVG aM aM $nP ]
    set sAM  [expr sqrt([TUarrayMath aM VAR AM aM $nP])]
    set guiAns(MA$Base)  [format "%.3e" $AM]
    set guiAns(MAs$Base)  [format "%.3e" $sAM]

    update
}
